/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineEventDispatcher.java 2704 2008-11-03 16:15:36Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eventswitch.client;


import org.mule.umo.UMOException;
import org.ow2.jasmine.event.beans.JasmineEventEB;
import org.ow2.jasmine.event.processor.JasmineEventProcessor;
import org.ow2.jasmine.event.processor.JasmineEventProcessorException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * Provide a processor that dispatches instances of {@link JasmineEventEB}.
 * @author Loris Bouzonnet
 */
public class JasmineEventDispatcher implements JasmineEventProcessor<DispatcherContext> {

    /**
     * Logger.
     */
    private static Log logger = LogFactory.getLog(JasmineEventDispatcher.class);


    /**
     * Dispatch the given event.
     * @param context a dispatcher context
     * @param event an event to send
     * @throws JasmineEventProcessorException if Mule cannot dispatch the event
     */
    private void dispatchEvent(final DispatcherContext context, final JasmineEventEB event)
    throws JasmineEventProcessorException {
        try {
            context.getClient().dispatch(context.getJasmineURI(), event, null);
        } catch (UMOException e) {
            logger.error("Unable to send the event at " + context.getJasmineURI(), e);
            throw new JasmineEventProcessorException(
                    "Unable to send the event at " + context.getJasmineURI(), e);
        }
    }

    /**
     * Process the given JASMINe event by dispatching it the Mule client.
     * @param context a dispatcher context
     * @param event an event to process
     * @throws JasmineEventProcessorException if Mule cannot dispatch the event
     */
    public void process(final DispatcherContext context, final JasmineEventEB event)
            throws JasmineEventProcessorException {
        dispatchEvent(context, event);
    }

}
