/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.event.processor.outer;

import java.io.PrintStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.ow2.jasmine.event.beans.JasmineEventEB;
import org.ow2.jasmine.event.processor.JasmineEventProcessor;
import org.ow2.jasmine.monitoring.mbeancmd.event.processor.outer.OuterContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OuterProcessor
implements JasmineEventProcessor<OuterContext> {
    public static final SimpleDateFormat SIMPLEDATEFORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private OuterContext context;

    public void process(OuterContext context, JasmineEventEB event) {
        this.context = context;
        this.printMBeanPoll(event.getDomain(), event.getServer(), event.getSource(), event.getProbe(), event.getSname(), event.getTimestamp().getTime(), event.getValue());
    }

    private void printMBeanPoll(String domain, String server, String source, String probe, String sname, Long timestamp, Serializable value) {
        PrintStream pout = this.context.getPout();
        String separator = this.context.getSeparator();
        pout.println(this.getMBeanPollHeader(probe, value));
        Date d = new Date(timestamp);
        pout.print(SIMPLEDATEFORMAT.format(d));
        pout.print(separator);
        pout.print(d.getTime());
        pout.print(separator);
        pout.print(sname);
        pout.print(separator);
        pout.print(server);
        pout.print(separator);
        pout.print(domain);
        pout.print(separator);
        pout.print(source);
        pout.print(separator);
        pout.print(this.getStringValue(value));
        pout.println();
    }

    private String getStringValue(Object value) {
        String separator = this.context.getSeparator();
        String stringValue = null;
        if (value != null) {
            if (value instanceof Map) {
                Map mappedValue = (Map)value;
                String sep = "";
                for (String key : mappedValue.keySet()) {
                    stringValue = stringValue + sep + mappedValue.get(key).toString();
                    sep = separator;
                }
            } else {
                stringValue = value.toString();
            }
        }
        return stringValue;
    }

    private String getMBeanPollHeader(String probe, Object value) {
        String separator = this.context.getSeparator();
        StringBuffer buf = new StringBuffer(512);
        buf.append("date");
        buf.append(separator);
        buf.append("time");
        buf.append(separator);
        buf.append("sname");
        buf.append(separator);
        buf.append("server");
        buf.append(separator);
        buf.append("domain");
        buf.append(separator);
        buf.append("mbean");
        buf.append(separator);
        buf.append(this.getStringKey(probe, value));
        this.context.setHeader(buf.toString());
        return this.context.getHeader();
    }

    private Object getStringKey(String probe, Object value) {
        String separator = this.context.getSeparator();
        String stringKey = null;
        if (value != null && value instanceof Map) {
            Map mappedValue = (Map)value;
            String sep = "";
            for (String key : mappedValue.keySet()) {
                stringKey = stringKey + sep + probe + "_" + key;
                sep = separator;
            }
        }
        if (stringKey == null) {
            stringKey = probe;
        }
        return stringKey;
    }
}

