/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DispatcherContext.java 8156 2011-05-13 15:40:30Z jlegrand $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eventswitch.client;

import org.mule.extras.client.MuleClient;
import org.mule.umo.UMOException;
import org.ow2.jasmine.event.processor.ProcessContext;
import org.ow2.jasmine.event.processor.ProcessContextException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * Context of a JASMINe event dispatcher.
 * It handles a Mule client.
 * @author Loris Bouzonnet
 */
public class DispatcherContext implements ProcessContext {

    /**
     * Logger.
     */
    private static Log logger = LogFactory.getLog(DispatcherContext.class);

    /**
     * An URI of a Mule inbound endpoint.
     */
    private String jasmineURI;

    /**
     * A Mule client to dispatch events.
     */
    private MuleClient client;

    /**
     * @return A Mule client
     */
    public final MuleClient getClient() {
        return client;
    }

    /**
     * @return an URI of a Mule inbound endpoint
     */
    public String getJasmineURI() {
        return jasmineURI;
    }

    /**
     * Set an URI of a Mule inbound endpoint.
     * @param jasmineURI an URI of a Mule inbound endpoint
     */
    public void setJasmineURI(final String jasmineURI) {
        this.jasmineURI = jasmineURI;
    }

    /**
     * Create a Mule client.
     * @throws ProcessContextException if a Mule client cannot be initialized
     */
    public void start() throws ProcessContextException {
        try {
            client = new MuleClient();
        } catch (UMOException e) {
            logger.error("Unable to initialize a Mule client", e);
            throw new ProcessContextException("Unable to initialize a Mule client", e);
        }
    }

    /**
     * Dispose the MuleManager instance if a new instance was created for this client.
     */
    public void stop() {
        client.dispose();
    }

}
