/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: OuterContext.java 8156 2011-05-13 15:40:30Z jlegrand $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.mbeancmd.event.processor.outer;

import java.io.File;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.io.PrintStream;

import org.ow2.jasmine.event.processor.ProcessContext;
import org.ow2.jasmine.event.processor.ProcessContextException;
import org.ow2.jasmine.monitoring.mbeancmd.Outer;
import org.ow2.jasmine.monitoring.mbeancmd.graph.Grapher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * Context of an outer processor.
 * It handles an {@link Outer}.
 * @author Loris Bouzonnet
 */
public class OuterContext implements ProcessContext {

    /**
     * Logger.
     */
    private static Log logger = LogFactory.getLog(OuterContext.class);

    /**
     * An outer.
     */
    Outer outer = null;

    /**
     * Header to use.
     */
    private String header = null;

    /**
     * Separator to use.
     */
    private String separator = ";";

    /**
     * Output stream.
     */
    private PrintStream pout = null;

    /**
     * Output file path, null for no file output.
     */
    private String outputFilePath;

    /**
     * Graph definitions, null for no graph output.
     */
    private String graphDef;

    public final String getOutputFilePath() {
        return outputFilePath;
    }

    public String getHeader() {
        return header;
    }

    public void setHeader(final String header) {
        this.header = header;
    }

    public String getSeparator() {
        return separator;
    }

    public void setSeparator(final String separator) {
        this.separator = separator;
    }

    public PrintStream getPout() {
        return pout;
    }

    public void setOutputFilePath(final String outputFilePath) {
        this.outputFilePath = outputFilePath;
    }

    public void setGraphDef(final String graphDef) {
        this.graphDef = graphDef;
    }


    public final String getGraphDef() {
        return graphDef;
    }

    /**
     * Create and start an {@link Outer}.
     * @throws ProcessContextException if the outer cannot be started
     */
    public void start() throws ProcessContextException {
        try {
            this.pout = getPrintStream(getOutputFilePath());
        } catch (IOException e) {
            logger.error("Unable to get a print stream for " + getOutputFilePath(), e);
            throw new ProcessContextException(
                    "Unable to get a print stream for " + getOutputFilePath(), e);
        }

        if (getGraphDef() != null) {
                PipedOutputStream sink = new PipedOutputStream();
                outer.setSink(sink);
                Grapher gr;
                try {
                    gr = new Grapher(sink, getGraphDef());
                } catch (IOException e) {
                    logger.error("Unable to create a grapher for " + getGraphDef(), e);
                    throw new ProcessContextException(
                            "Unable to create a grapher for " + getGraphDef(), e);
                }
                gr.start();
        }
        new Thread(outer).start();
    }

    /**
     *
     */
    public void stop() {
    }

    private PrintStream getPrintStream(final String outputFilePath) throws IOException {

        PipedOutputStream out = new PipedOutputStream();
        if (outputFilePath != null) {
            outer = new Outer(out, new File(outputFilePath));
        } else {
            outer = new Outer(out, System.out);
        }
        return new PrintStream(out);
    }

}
