/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import javax.management.Attribute;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;

public class DSData
extends SampleData {
    private static final String header = "servedRate;servedOpen;jdbcMaxConnPool;currentOpen;busyMax;waitersHighRecent;waitingHighRecent;meanWaitTime;rejectedOpen;connectionLeaks";

    public void compute(SampleData needs_cast) {
        DSData prev = (DSData)needs_cast;
        if (prev != null) {
            int deltaServedOpen = this.getAttributeAsInt("servedOpen") - prev.getAttributeAsInt("servedOpen");
            double dt = (double)(this.getSampleTime() - prev.getSampleTime()) / 1000.0;
            this.setAttribute(new Attribute("servedOpenRate", new Double((double)deltaServedOpen / dt)));
            int deltaWaiters = this.getAttributeAsInt("waiterCount") - prev.getAttributeAsInt("waiterCount");
            long deltaWaitTime = this.getAttributeAsLong("waitingTime") - prev.getAttributeAsLong("waitingTime");
            double meanWaitTime = deltaWaiters > 0 ? 1.0 * (double)deltaWaitTime / (double)deltaWaiters : 0.0;
            this.setAttribute(new Attribute("meanWaitTime", new Double(meanWaitTime)));
        } else {
            this.setAttribute(new Attribute("servedOpenRate", new Double(0.0)));
            this.setAttribute(new Attribute("meanWaitTime", new Double(0.0)));
        }
    }

    protected String getInnerPrintHeader() {
        return header.replaceAll(";", DSData.getSeparator());
    }

    protected String getInnerPrintData() {
        return decimalFormat.format(this.getAttributeAsDouble("servedOpenRate")) + DSData.getSeparator() + this.getAttributeAsInt("servedOpen") + DSData.getSeparator() + this.getAttributeAsInt("jdbcMaxConnPool") + DSData.getSeparator() + this.getAttributeAsInt("currentOpened") + DSData.getSeparator() + this.getAttributeAsInt("busyMax") + DSData.getSeparator() + this.getAttributeAsInt("waitersHighRecent") + DSData.getSeparator() + this.getAttributeAsLong("waitingHighRecent") + DSData.getSeparator() + decimalFormat.format(this.getAttributeAsDouble("meanWaitTime")) + DSData.getSeparator() + this.getAttributeAsInt("rejectedOpen") + DSData.getSeparator() + this.getAttributeAsInt("connectionLeaks");
    }
}

