/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import javax.management.Attribute;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;

public class JCACFData
extends SampleData {
    private static final String header = "servedRate;servedOpen;maxSize;currentOpen;currentBusy;busyMax;currentWaiters;waitersHighRecent;waitingHighRecent;meanWaitTime;rejectedOpen;connectionLeaks";

    public void compute(SampleData needs_cast) {
        JCACFData prev = (JCACFData)needs_cast;
        if (prev != null) {
            int deltaServedOpen = this.getAttributeAsInt("servedOpen") - prev.getAttributeAsInt("servedOpen");
            double dt = (double)(this.getSampleTime() - prev.getSampleTime()) / 1000.0;
            this.setAttribute(new Attribute("servedOpenRate", new Double((double)deltaServedOpen / dt)));
            int deltaWaiters = this.getAttributeAsInt("waiterCount") - prev.getAttributeAsInt("waiterCount");
            long deltaWaitTime = this.getAttributeAsLong("waitingTime") - prev.getAttributeAsLong("waitingTime");
            double meanWaitTime = deltaWaiters > 0 ? 1.0 * (double)deltaWaitTime / (double)deltaWaiters : 0.0;
            this.setAttribute(new Attribute("meanWaitTime", new Double(meanWaitTime)));
        } else {
            this.setAttribute(new Attribute("servedOpenRate", new Double(0.0)));
            this.setAttribute(new Attribute("meanWaitTime", new Double(0.0)));
        }
    }

    protected String getInnerPrintHeader() {
        return header.replaceAll(";", JCACFData.getSeparator());
    }

    protected String getInnerPrintData() {
        return decimalFormat.format(this.getAttributeAsDouble("servedOpenRate")) + JCACFData.getSeparator() + this.getAttributeAsInt("servedOpen") + JCACFData.getSeparator() + this.getAttributeAsInt("maxSize") + JCACFData.getSeparator() + this.getAttributeAsInt("currentOpened") + JCACFData.getSeparator() + this.getAttributeAsInt("currentBusy") + JCACFData.getSeparator() + this.getAttributeAsInt("busyMax") + JCACFData.getSeparator() + this.getAttributeAsInt("currentWaiters") + JCACFData.getSeparator() + this.getAttributeAsInt("waitersHighRecent") + JCACFData.getSeparator() + this.getAttributeAsLong("waitingHighRecent") + JCACFData.getSeparator() + decimalFormat.format(this.getAttributeAsDouble("meanWaitTime")) + JCACFData.getSeparator() + this.getAttributeAsInt("rejectedOpen") + JCACFData.getSeparator() + this.getAttributeAsInt("connectionLeaks");
    }
}

