/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;

public class ServletData
extends SampleData {
    private int requestCount;
    private int errorCount;
    private long processingTime;
    private long maxTime;
    private long minTime;
    private double requestRate;
    private double errorRate;
    private double procTimeReq;
    private static final String header = "requestCount;requestRate;errorCount;errorRate;procTimeReq;maxTime;minTime";

    public void compute(SampleData needs_cast) {
        ServletData prev = (ServletData)needs_cast;
        if (prev != null) {
            int deltaReq = this.requestCount - prev.requestCount;
            double dt = (double)(this.getSampleTime() - prev.getSampleTime()) / 1000.0;
            this.setRequestRate((double)deltaReq / dt);
            int deltaErr = this.errorCount - prev.errorCount;
            this.setErrorRate((double)deltaErr / dt);
            long deltaTime = this.processingTime - prev.processingTime;
            if (deltaReq > 0) {
                this.setProcTimeReq(1.0 * (double)deltaTime / (double)deltaReq);
            } else {
                this.setProcTimeReq(0.0);
            }
        }
    }

    protected String getInnerPrintHeader() {
        return header.replaceAll(";", ServletData.getSeparator());
    }

    protected String getInnerPrintData() {
        return this.getRequestCount() + ServletData.getSeparator() + decimalFormat.format(this.getRequestRate()) + ServletData.getSeparator() + this.getErrorCount() + ServletData.getSeparator() + decimalFormat.format(this.getErrorRate()) + ServletData.getSeparator() + decimalFormat.format(this.getProcTimeReq()) + ServletData.getSeparator() + this.getMaxTime() + ServletData.getSeparator() + this.getMinTime();
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(int requestCount) {
        this.requestCount = requestCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public void setProcessingTime(long processingTime) {
        this.processingTime = processingTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public void setMinTime(long minTime) {
        this.minTime = minTime;
    }

    public double getRequestRate() {
        return this.requestRate;
    }

    protected void setRequestRate(double requestRate) {
        this.requestRate = requestRate;
    }

    public double getErrorRate() {
        return this.errorRate;
    }

    protected void setErrorRate(double errorRate) {
        this.errorRate = errorRate;
    }

    public double getProcTimeReq() {
        return this.procTimeReq;
    }

    protected void setProcTimeReq(double procTimeReq) {
        this.procTimeReq = procTimeReq;
    }
}

