/**
 * JASMINe
 * Copyright (C) 2007 SERLI Informatique
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.interfaces.jmx.alarms;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;


/**
 * Interface of the MBean dedicated to alarms.<br><br>
 * This MBean supplies methods to retrieve alarm information by giving their id.<br>
 * 
 * @author Awa OUEDRAOGO
 * @author Laurent RUAUD
 */
public interface JMXAlarmManagerMBean {

    /**
     * Sends a notification to the MBean server.
     * 
     * @param id id of the alarm to be notified.
     */
	public CompositeData getAlarm(int id);

    /**
     * Retrieves information on the specified alarm from the log interface.
     *  
     * @param id id of the alarm.
     * @return a composite object containing a copy of alarm's information.
     */
	public TabularData getLastAlarms(int nb);
    
    /**
     * Retrieves information on the last raised alarms from the log interface.
     * The maximum number of alarm to retrieve must be specified.
     *  
     * @param nb number of alarms to retrieve.
     * @return a tabular object containing copies of alarm's information.
     */
	public TabularData getAlarmRange(int lowid, int highid);
}
