/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.interfaces.jmx.alarms;

import java.util.HashMap;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.jasmine.rules.logs.beans.LogInterfaceLocal;
import org.objectweb.jasmine.rules.logs.util.AlarmLog;
import org.ow2.jasmine.interfaces.jmx.alarms.JMXAlarmManagerMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXAlarmManager
extends NotificationBroadcasterSupport
implements JMXAlarmManagerMBean {
    private static JMXAlarmManager instance;
    private static ObjectName objectName;
    private CompositeType alarmCompositeType;
    private TabularType alarmTabularType;

    public static JMXAlarmManager getInstance() {
        if (instance == null) {
            instance = new JMXAlarmManager();
        }
        return instance;
    }

    public static ObjectName getObjectName() {
        if (objectName == null) {
            try {
                objectName = new ObjectName("JASMINe:name=Alarm Manager");
            }
            catch (MalformedObjectNameException e) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return objectName;
    }

    private JMXAlarmManager() {
        try {
            this.alarmCompositeType = new CompositeType("JASMINe Alarm Composite", "JASMINe Alarm Informations", new String[]{"ID", "Date", "Level", "Message"}, new String[]{"Alarm persistence ID", "Alarm occuration date", "Alarm severity level", "Alarm brought message"}, new OpenType[]{SimpleType.INTEGER, SimpleType.DATE, SimpleType.STRING, SimpleType.STRING});
            this.alarmTabularType = new TabularType("JASMINe Alarm Tabular", "JASMINe Alarm Table", this.alarmCompositeType, new String[]{"ID"});
        }
        catch (OpenDataException e) {
            System.err.println("Invalid argument given during types creation: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void notifyAlarm(int id) {
        Notification notif = new Notification("JASMINe Alarm", (Object)objectName, (long)id, "An alarm has been raised");
        notif.setUserData(id);
        this.sendNotification(notif);
    }

    @Override
    public CompositeData getAlarm(int id) {
        CompositeData log = null;
        try {
            InitialContext ctx = new InitialContext();
            LogInterfaceLocal logInterface = (LogInterfaceLocal)ctx.lookup("org.objectweb.jasmine.rules.logs.LogInterface_" + LogInterfaceLocal.class.getName() + "@Local");
            log = this.compositeFromLog(logInterface.getLog(id));
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return log;
    }

    @Override
    public TabularData getLastAlarms(int nb) {
        TabularData logs = null;
        try {
            InitialContext ctx = new InitialContext();
            LogInterfaceLocal logInterface = (LogInterfaceLocal)ctx.lookup("org.objectweb.jasmine.rules.logs.LogInterface_" + LogInterfaceLocal.class.getName() + "@Local");
            logs = this.tabularFromLogList(logInterface.getLastLogs(nb));
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return logs;
    }

    @Override
    public TabularData getAlarmRange(int lowid, int highid) {
        TabularData logs = null;
        try {
            InitialContext ctx = new InitialContext();
            LogInterfaceLocal logInterface = (LogInterfaceLocal)ctx.lookup("org.objectweb.jasmine.rules.logs.LogInterface_" + LogInterfaceLocal.class.getName() + "@Local");
            logs = this.tabularFromLogList(logInterface.getLogRange(lowid, highid));
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return logs;
    }

    private CompositeData compositeFromLog(AlarmLog log) {
        if (log == null) {
            return null;
        }
        try {
            HashMap<String, Object> alarmMapData = new HashMap<String, Object>();
            alarmMapData.put("ID", log.getId());
            alarmMapData.put("Date", log.getDate());
            alarmMapData.put("Level", log.getLevel());
            alarmMapData.put("Message", log.getMessage());
            return new CompositeDataSupport(this.alarmCompositeType, alarmMapData);
        }
        catch (OpenDataException e) {
            System.err.println("Invalid argument given during composite creation: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private TabularData tabularFromLogList(List<AlarmLog> logs) {
        TabularDataSupport alarmTabularData = new TabularDataSupport(this.alarmTabularType);
        for (AlarmLog log : logs) {
            alarmTabularData.put(this.compositeFromLog(log));
        }
        return alarmTabularData;
    }

    static {
        objectName = null;
    }
}

