/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.interfaces.jmx;

import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.ow2.jasmine.interfaces.jmx.alarms.JMXAlarmManager;

public class JMXResourceAdapter
implements ResourceAdapter {
    private MBeanServer server;
    private List<ObjectName> names = new ArrayList<ObjectName>();

    public void start(BootstrapContext arg0) throws ResourceAdapterInternalException {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        this.server = servers.size() > 0 ? (MBeanServer)servers.get(0) : MBeanServerFactory.createMBeanServer(null);
        this.register(JMXAlarmManager.getInstance(), JMXAlarmManager.getObjectName());
        this.names.add(JMXAlarmManager.getObjectName());
    }

    public void stop() {
        for (ObjectName name : this.names) {
            try {
                this.server.unregisterMBean(name);
            }
            catch (InstanceNotFoundException e) {
                System.err.println("Unable to unregister a name of a JMX external interface: " + name);
                e.printStackTrace();
            }
            catch (MBeanRegistrationException e) {
                System.err.println("Unable to unregister a name of a JMX external interface: " + name);
                e.printStackTrace();
            }
        }
    }

    private void register(Object object, ObjectName name) {
        try {
            if (this.server.isRegistered(name)) {
                this.server.unregisterMBean(name);
            }
            this.server.registerMBean(object, name);
        }
        catch (InstanceNotFoundException e) {
            System.err.println("Unable to register a name of a JMX external interface: " + name);
            e.printStackTrace();
        }
        catch (InstanceAlreadyExistsException e) {
            System.err.println("Unable to register a name of a JMX external interface: " + name);
            e.printStackTrace();
        }
        catch (MBeanRegistrationException e) {
            System.err.println("Unable to register a name of a JMX external interface: " + name);
            e.printStackTrace();
        }
        catch (NotCompliantMBeanException e) {
            System.err.println("Unable to register a name of a JMX external interface: " + name);
            e.printStackTrace();
        }
    }

    public void endpointActivation(MessageEndpointFactory arg0, ActivationSpec arg1) throws ResourceException {
    }

    public void endpointDeactivation(MessageEndpointFactory arg0, ActivationSpec arg1) {
    }

    public XAResource[] getXAResources(ActivationSpec[] arg0) throws ResourceException {
        return null;
    }
}

