/**
 * JASMINe
 * Copyright (C) 2007 SERLI Informatique
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.interfaces.snmp.alarms;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;


/**
 * Listener class of the SNMP interface related to alarms.<br><br>
 * Implements a Message Driven Bean to receive alarm messages.<br>
 * Creates and registers an MIB for alarms and managers.<br>
 * Notifies alarms through the SNMP agent.
 * 
 * @author Laurent RUAUD
 */
@MessageDriven(activationConfig = {
        @ActivationConfigProperty(propertyName = "destination", propertyValue = "JASMINeAlarmsTopic"),
        @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Topic")
        }
)
public class SNMPAlarmListener implements MessageListener {
    
    /**
     * Reacts to a message from the log interface.
     */
    public void onMessage(final Message message) {
        // Should be instance of text message
        if (message instanceof TextMessage) {
            try {
                int id = Integer.parseInt(((TextMessage) message).getText());
                SNMPAlarmMIB.getInstance().notifyAlarm(id);
            } catch (JMSException e) {
                System.err.println("Unable to notify this alarm through SNMP: Error while getting the content of the message.");
                e.printStackTrace();
            }
        }
    }
}
