/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.interfaces.snmp.alarms;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.jasmine.rules.logs.AlarmLog;
import org.objectweb.jasmine.rules.logs.LogInterfaceLocal;
import org.ow2.jasmine.interfaces.snmp.SNMPAgent;
import org.ow2.jasmine.interfaces.snmp.alarms.SNMPAlarm;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class SNMPAlarmMIB
implements MOGroup {
    public static final OID oidJASMINe = new OID(new int[]{1, 3, 6, 1, 2, 1, 133});
    public static final OID oidJASMINeAlarms = new OID(oidJASMINe.getValue(), new int[]{1});
    public static final OID oidJASMINeAlarmObjects = new OID(oidJASMINeAlarms.getValue(), new int[]{1});
    public static final OID oidAlarmDataTable = new OID(oidJASMINeAlarmObjects.getValue(), new int[]{1});
    public static final OID oidAlarmDataEntry = new OID(oidAlarmDataTable.getValue(), new int[]{1});
    public static final OID oidAlarmDataEntryIndex = new OID(oidAlarmDataEntry.getValue(), new int[]{1});
    public static final OID oidJASMINeAlarmNotifications = new OID(oidJASMINeAlarms.getValue(), new int[]{2});
    public static final OID oidAlarmRaised = new OID(oidJASMINeAlarmNotifications.getValue(), new int[]{0, 1});
    private static SNMPAlarmMIB instance;
    private MOTable alarmDataTable;

    public static SNMPAlarmMIB getInstance() {
        if (instance == null) {
            instance = new SNMPAlarmMIB();
        }
        return instance;
    }

    private SNMPAlarmMIB() {
        this.createAlarmDataEntry();
    }

    public void notifyAlarm(int id) {
        SNMPAlarm alarm = new SNMPAlarm(id);
        this.alarmDataTable.addRow((MOTableRow)alarm);
        SNMPAgent.getInstance().notify(new OctetString(), oidAlarmRaised, new VariableBinding[]{new VariableBinding(new OID(oidAlarmDataEntryIndex.getValue(), new int[]{id}), (Variable)new Gauge32((long)id))});
    }

    public AlarmLog getAlarm(int id) {
        AlarmLog log = null;
        try {
            InitialContext ctx = new InitialContext();
            LogInterfaceLocal logInterface = (LogInterfaceLocal)ctx.lookup("org.objectweb.jasmine.rules.logs.LogInterface_" + LogInterfaceLocal.class.getName() + "@Local");
            log = logInterface.getLog(id);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return log;
    }

    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register((ManagedObject)this.alarmDataTable, context);
    }

    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister((ManagedObject)this.alarmDataTable, context);
    }

    private void createAlarmDataEntry() {
        MOFactory moFactory = DefaultMOFactory.getInstance();
        MOColumn[] columns = new MOColumn[]{moFactory.createColumn(1, 66, MOAccessImpl.ACCESS_READ_ONLY), moFactory.createColumn(2, 4, MOAccessImpl.ACCESS_READ_ONLY), moFactory.createColumn(3, 4, MOAccessImpl.ACCESS_READ_ONLY), moFactory.createColumn(4, 4, MOAccessImpl.ACCESS_READ_ONLY)};
        MOTableIndex alarmDataTableIndex = moFactory.createIndex(new MOTableSubIndex[]{moFactory.createSubIndex(oidAlarmDataEntryIndex, 66)}, false);
        this.alarmDataTable = moFactory.createTable(oidAlarmDataEntry, alarmDataTableIndex, columns);
    }
}

