/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.interfaces.snmp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.BaseAgent;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.TransportDomains;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.TransportMappings;

public class SNMPAgent
extends BaseAgent {
    private static String DEFAULT_REQUEST_SOURCE = "127.0.0.1/1161";
    private ArrayList<MOGroup> registeredMibs;
    private ArrayList<String> registeredDestinations;
    private String requestSource = DEFAULT_REQUEST_SOURCE;
    private static SNMPAgent instance;

    public static SNMPAgent getInstance() {
        if (instance == null) {
            instance = new SNMPAgent();
        }
        return instance;
    }

    private SNMPAgent() {
        super(new File("AgentConfig.cfg"), new File("AgentBootCounter.cfg"), new CommandProcessor(new OctetString(MPv3.createLocalEngineID())));
        this.registeredMibs = new ArrayList();
        this.registeredDestinations = new ArrayList();
    }

    public void start() {
        try {
            this.init();
        }
        catch (IOException e) {
            System.err.println("Unable to start the SNMP agent: " + e.getMessage());
            e.printStackTrace();
        }
        this.getServer().addContext(new OctetString("public"));
        this.finishInit();
        this.run();
    }

    public void stop() {
        this.unregisterManagedObjects();
    }

    public void setRequestSource(String source) {
        this.requestSource = source;
    }

    public void addTrapDestination(String trapDestination) {
        this.registeredDestinations.add(trapDestination);
    }

    public void notify(OctetString context, OID notificationID, VariableBinding[] vbs) {
        this.notificationOriginator.notify(context, notificationID, vbs);
    }

    public void registerMIB(MOGroup mib) {
        try {
            mib.registerMOs((MOServer)this.server, null);
        }
        catch (DuplicateRegistrationException e) {
            e.printStackTrace();
        }
    }

    public void unregisterMIB(MOGroup mib) {
        mib.unregisterMOs((MOServer)this.server, null);
    }

    protected void registerManagedObjects() {
    }

    protected void unregisterManagedObjects() {
        for (MOGroup mib : this.registeredMibs) {
            mib.unregisterMOs((MOServer)this.server, null);
        }
    }

    protected void addCommunities(SnmpCommunityMIB communityMIB) {
        Variable[] values = new Variable[]{new OctetString("public"), new OctetString("public"), this.getAgent().getContextEngineID(), new OctetString(), new OctetString(), new Integer32(3), new Integer32(1)};
        MOTableRow row = communityMIB.getSnmpCommunityEntry().createRow(new OctetString("public2public").toSubIndex(true), values);
        communityMIB.getSnmpCommunityEntry().addRow(row);
    }

    protected void addNotificationTargets(SnmpTargetMIB targetMIB, SnmpNotificationMIB notificationMIB) {
        targetMIB.addDefaultTDomains();
        for (String destination : this.registeredDestinations) {
            targetMIB.addTargetAddress(new OctetString("notif" + destination), TransportDomains.transportDomainUdpIpv4, new OctetString(new UdpAddress(destination).getValue()), 1500, 3, new OctetString("notify"), new OctetString("v2c"), 4);
        }
        targetMIB.addTargetParams(new OctetString("v2c"), 1, 2, new OctetString("public"), 1, 4);
        notificationMIB.addNotifyEntry(new OctetString("default"), new OctetString("notify"), 1, 4);
    }

    protected void addUsmUser(USM usm) {
    }

    protected void addViews(VacmMIB vacm) {
        vacm.addGroup(1, new OctetString("public"), new OctetString("v1v2group"), 3);
        vacm.addGroup(2, new OctetString("public"), new OctetString("v1v2group"), 3);
        vacm.addAccess(new OctetString("v1v2group"), new OctetString(), 0, 1, 1, new OctetString("fullReadView"), new OctetString("fullWriteView"), new OctetString("fullNotifyView"), 3);
        vacm.addViewTreeFamily(new OctetString("fullReadView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullWriteView"), new OID("1.3"), new OctetString(), 1, 3);
        vacm.addViewTreeFamily(new OctetString("fullNotifyView"), new OID("1.3"), new OctetString(), 1, 3);
    }

    protected void initTransportMappings() throws IOException {
        Address addr = GenericAddress.parse((String)this.requestSource);
        TransportMapping tm = TransportMappings.getInstance().createTransportMapping(addr);
        if (tm == null) {
            System.err.println("Unable to establish a connection using address: " + this.requestSource);
            if (!this.requestSource.equals(DEFAULT_REQUEST_SOURCE)) {
                System.err.println("Will try with default values: " + DEFAULT_REQUEST_SOURCE);
                addr = GenericAddress.parse((String)DEFAULT_REQUEST_SOURCE);
                tm = TransportMappings.getInstance().createTransportMapping(addr);
                if (tm == null) {
                    System.err.println("Unable to establish a connection using default values.");
                }
            }
        }
        this.transportMappings = new TransportMapping[1];
        this.transportMappings[0] = tm;
    }
}

