/**
 * JASMINe
 * Copyright (C) 2007 SERLI Informatique
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.interfaces.snmp.alarms;

import org.objectweb.jasmine.rules.logs.util.AlarmLog;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

/**
 * MIB implementation for alarms.<br><br>
 * Represents an alarm as a table row.
 * 
 * @author Laurent RUAUD
 */
public class SNMPAlarm implements MOTableRow {
    /** The object identifier for this row */
	private OID index;
	/** The id of the referenced alarm */
	private int id;

    /** The number of column in each row */
	public static int COLUMN_COUT = 4;
	
    /**
     * Creates a row referencing the specified alarm.
     * 
     * @param index the object identifier for this row.
     * @param id id of the alarm to be referenced..
     */
	public SNMPAlarm(int id) {
	    this.index = new OID("" + id);
	    this.id = id;
	}
	
    /**
     * Gets the row's index OID.
     * 
     * @return the object identifier for this row.
     */
	public OID getIndex() {
		return index;
	}

    /**
     * Gets the value at the specified column index.
     * 
     * @return the value at the specified column index.
     */
	public Variable getValue(int column) {
	    AlarmLog log = SNMPAlarmMIB.getInstance().getAlarm(id);

	    switch(column) {
		case 0: return new Gauge32(log.getId());
		case 1: return new OctetString(log.getDate().toString());
		case 2: return new OctetString(log.getLevel());
		case 3: return new OctetString(log.getMessage());
		default: return null;
		}
	}

    /**
     * Returns the number of columns in this row.
     * 
     * @return the number of columns in this row.
     */
	public int size() {
		return COLUMN_COUT;
	}

    /**
     * Gets the associated base row for this row (if this row is a dependent row).
     * 
     * @return null
     */
    public MOTableRow getBaseRow() {
        return null;
    }

    /**
     * Sets the associated base row. Not used.
     */
    public void setBaseRow(MOTableRow arg0) {
    }

}
