/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id: JasmineEventNotificationSLBRemote.java 4952 2009-08-17 19:39:38Z renaultgu $
 */

package org.ow2.jasmine.monitoring.eventswitch.beans;

import java.util.Date;
import java.util.List;

import org.ow2.jasmine.event.beans.JasmineEventNotification;
import org.ow2.jasmine.event.beans.JasmineEventNotificationExecutedAction;

/**
 * Interface for the JasmineEventNotification stateless bean.
 *
 * @author HAN Tianyi
 */
public interface JasmineEventNotificationSLBRemote {

    /**
     * Saves the action executed by a user in the DataBase.
     *
     * @param id the Id of the notification to update.
     * @param action the action to save.
     */
    void saveExecutedAction(final String id, final JasmineEventNotificationExecutedAction action);

    /**
     * Updates the status of the notification : acknowledge or not.
     *
     * @param id the id of the notification to update.
     * @param status the new status to save.
     */
    void updateNotificationStatus(final String id, final boolean status);

    /**
     * creates the JasmineEventNotification entity bean corresponding to given
     * datum and saves an event on the database.
     *
     * @see JasmineEventNotificationSLBRemote#saveEvent(JasmineEventNotificationEB)
     * @param n Notification to save.
     */
    void saveEvent(final JasmineEventNotification n);

    /**
     * looks for the beans searched for, converts the search into an array of
     * JasmineEventNotificationEB objects and returns.
     *
     * @see public JasmineEventNotification[] getEventNotifications(String,
     *      Date, String, String, Boolean, int, String, int);
     * @param id Notification id
     * @param date Notification date
     * @param level Notification level
     * @param message Associated message
     * @param status Notification status
     * @param rule The rule id that caused the notification
     * @param orderBy Order using column.
     * @param limit Maximal number of results to get.
     * @return EventNotifications corresponding to the given search, null if
     *         none found.
     */
    JasmineEventNotification[] getEventNotifications(final String id, final Date date, final String level,
        final String message, final Boolean status, final String rule, final String orderBy, final Integer limit);

    /**
     * Gets the event notification between two dates.
     *
     * @param dateFrom the date from
     * @param dateTo the date to
     * @return a list of {@link JasmineEventNotification}
     */
    List<JasmineEventNotification> getEventNotifications(final Date dateFrom, final Date dateTo);

    /**
     * Gets all the notification events from the DataBase.
     *
     * @return A list that contains all the {@link JasmineEventNotification}
     *         stored in the DataBase.
     */
    List<JasmineEventNotification> getAllNotifications();

    /**
     * Looks for the given bean in the data base. It returns the associated
     * {@link JasmineEventNotification}.
     *
     * @param id Id of the notification to retrieve.
     * @return the retrieved notification.
     */
    JasmineEventNotification getEventNotification(final String id);
}
