/**
 * JASMINe
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineEventSLBRemote.java 4798 2009-08-07 12:30:47Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eventswitch.beans;

import java.util.Date;

import org.ow2.jasmine.event.beans.JasmineEventEB;

/**
 * Remote interface for the JasmineEvent stateless bean.
 */
public interface JasmineEventSLBRemote {
    /**
     * Saves the event represented by the given JASMINe Event Entity Bean
     * mirror object on the database.
     *
     * @param e  Event to save.
     */
    void saveEvent(final JasmineEventEB e);

    /**
     * Gets the events corresponding to a given filter. If you do not need a
     * search criteria, just set it to null.
     *
     * @param domain          Domain of the probed server.
     * @param server          Name of the probed server.
     * @param source          Event source (for example, MBeanCmd or JMX).
     * @param probe           Probe type.
     * @param value           Probed value.
     * @param startTimestamp  Probe time bigger than.
     * @param endTimestamp    Probe time smaller than.
     * @param orderBy         Order using column.
     * @param limit           Maximal number of results to get.
     *
     * @return  Events corresponding to the given search, null if none found.
     */
    JasmineEventEB[] getEvents(final String domain, final String server, final String source, final String probe,
                               final String value, final Date startTimestamp, final Date endTimestamp,
                               final String orderBy, final int limit);
}
