/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.connectors;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.rmi.RMISecurityManager;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB3Connector<BeanType> {
    private BeanType remote = null;
    private Map<String, String> configuration = null;
    private static Map<String, String> keys = null;

    public final void setConfiguration(Map<String, String> conf) {
        this.configuration = conf;
    }

    protected final BeanType getBean() throws NamingException, IOException {
        if (this.remote == null) {
            this.connect();
        }
        return this.remote;
    }

    public void connect() throws NamingException, IOException {
        if (this.configuration == null) {
            throw new RuntimeException("This EJB3Connector has not been initialized");
        }
        if (Boolean.parseBoolean(this.configuration.get("Wrapper.INIT_SECURITY_MANAGER")) && System.getSecurityManager() == null) {
            if (System.getProperty("java.security.policy") == null) {
                File temp = File.createTempFile("java.security.policy.", ".tmp");
                FileOutputStream s = new FileOutputStream(temp);
                s.write("grant { permission java.security.AllPermission; };".getBytes());
                s.close();
                System.setProperty("java.security.policy", temp.toString());
            }
            System.setSecurityManager(new RMISecurityManager());
        }
        Hashtable<String, String> env = new Hashtable<String, String>(this.configuration.size() - 1);
        for (String k : keys.keySet()) {
            String value = this.configuration.get("Context." + k);
            if (value == null) continue;
            env.put(keys.get(k), value);
        }
        InitialContext initialContext = new InitialContext(env);
        this.remote = initialContext.lookup(this.configuration.get("Wrapper.LOOKUP_BEAN"));
    }

    public void disconnect() {
        this.remote = null;
    }

    static {
        keys = new TreeMap<String, String>();
        for (Field f : Context.class.getFields()) {
            try {
                if (!f.getType().equals(String.class)) continue;
                keys.put(f.getName(), (String)f.get(null));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

