/**
 * JASMINe
 * Copyright (C) 2007-2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eventswitch.beans;

import java.util.List;

import org.ow2.jasmine.event.messages.JasmineEventPurgeTask;

/**
 * Remote interface for the JasmineEvent stateless purge task bean.
 * @author Francois Fornaciari
 */
public interface JasmineEventPurgeTaskSLBRemote {

    /**
     * Creates and persists a new purge task. This tasks can be executed periodically.
     * @param event Purge task to create.
     * @return The purge task for which the id and the start date have been set.
     */
    JasmineEventPurgeTask configurePurgeTask(final JasmineEventPurgeTask event);

    /**
     * List of persisted purge tasks.
     * @return List of persisted purge tasks
     */
    List<JasmineEventPurgeTask> listPurgeTasks();

    /**
     * Creates timers for persisted periodic purge tasks.
     * This method is called at application startup by the InitServlet.init() method
     */
    void activatePeriodicPurgeTasks();

    /**
     * Remove a given purge task.
     * @param purgeTaskId Purge task id
     * @return Id of the removed purge task
     */
    long removePurgeTask(long purgeTaskId);

    /**
     * Starts a given purge task.
     * @param purgeTaskId Purge task id
     * @return Id of the started task
     */
    long startPurgeTask(long purgeTaskId);

    /**
     * Pauses a given purge task.
     * @param purgeTaskId Purge task id
     * @return Id of the paused task
     */
    long pausePurgeTask(long purgeTaskId);

}
