/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.extractor;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeSet;
import javax.naming.NamingException;
import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventEB;
import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventSLBRemote;
import org.ow2.jasmine.monitoring.eventswitch.connectors.EJB3Connector;
import org.ow2.jasmine.monitoring.eventswitch.extractor.ArgumentParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JasmineEventDataExtractor
extends EJB3Connector<JasmineEventSLBRemote> {
    private SimpleDateFormat formatter = null;

    public static void main(String[] args) throws NamingException, ParseException, IOException {
        new JasmineEventDataExtractor(args);
    }

    protected JasmineEventDataExtractor(String[] args) throws NamingException, ParseException, IOException {
        ArgumentParser p = new ArgumentParser(args);
        this.setConfiguration(p.getOptions());
        String format = p.getOption("timeformat");
        if (format != null || "long".equalsIgnoreCase(format)) {
            this.formatter = new SimpleDateFormat(format);
        }
        int limit = 1000;
        try {
            Integer.parseInt(p.getOption("limit"));
        }
        catch (Exception e) {
            System.err.println("No limit specified: defaulting to 1000.");
        }
        this.connect();
        this.extractEvents(((JasmineEventSLBRemote)this.getBean()).getEvents(p.getOption("domain"), p.getOption("server"), p.getOption("source"), p.getOption("probe"), p.getOption("value"), this.getTime(p.getOption("startTimestamp")), this.getTime(p.getOption("endTimestamp")), "timestamp", limit));
        this.disconnect();
    }

    protected void extractEvents(JasmineEventEB[] events) {
        if (events == null) {
            return;
        }
        TreeSet<String> attributes = new TreeSet<String>();
        for (JasmineEventEB event : events) {
            attributes.add(event.getProbe().substring(event.getProbe().lastIndexOf(58) + 1));
        }
        System.out.print("date;time;server;domain;mbean");
        for (String attribute : attributes) {
            System.out.print(";");
            System.out.print(attribute);
        }
        System.out.println();
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        for (JasmineEventEB event : events) {
            System.out.print(df.format(event.getTimestamp()));
            System.out.print(";");
            System.out.print(event.getTimestamp().getTime());
            System.out.print(";");
            System.out.print(event.getServer());
            System.out.print(";");
            System.out.print(event.getDomain());
            System.out.print(";");
            System.out.print(event.getProbe().substring(0, event.getProbe().lastIndexOf(58)));
            String attribute = event.getProbe().substring(event.getProbe().lastIndexOf(58) + 1);
            for (String cAttribute : attributes) {
                System.out.print(";");
                if (!cAttribute.equals(attribute)) continue;
                System.out.print(event.getValue());
            }
            System.out.println();
        }
    }

    protected Date getTime(String s) throws ParseException {
        if (s == null) {
            return null;
        }
        if (this.formatter == null) {
            return new Date(Long.parseLong(s));
        }
        return this.formatter.parse(s);
    }
}

