/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.smartclient.message;

import java.nio.ByteBuffer;
import org.ow2.easybeans.component.smartclient.message.AbsMessage;

public abstract class AbsNameBytesMessage
extends AbsMessage {
    private String name = null;
    private byte[] bytes = null;

    public AbsNameBytesMessage(String name, byte[] bytes) {
        this.name = name;
        this.bytes = bytes;
    }

    public AbsNameBytesMessage(ByteBuffer dataBuffer) {
        int lengthName = dataBuffer.getInt();
        ByteBuffer nameBuffer = ByteBuffer.allocate(lengthName);
        for (int l = 0; l < lengthName; ++l) {
            byte b = dataBuffer.get();
            nameBuffer.put(b);
        }
        nameBuffer.position(0);
        this.name = this.decode(nameBuffer);
        this.bytes = new byte[dataBuffer.limit() - dataBuffer.position()];
        int k = 0;
        for (int i = dataBuffer.position(); i < dataBuffer.limit(); ++i) {
            this.bytes[k++] = dataBuffer.get(i);
        }
    }

    public abstract byte getOpCode();

    public ByteBuffer getSubMessage() {
        ByteBuffer nameBuffer = this.encode(this.name);
        nameBuffer.position(0);
        ByteBuffer messageBuffer = ByteBuffer.allocate(4 + nameBuffer.capacity() + this.bytes.length);
        messageBuffer.putInt(nameBuffer.capacity());
        messageBuffer.put(nameBuffer);
        messageBuffer.put(this.bytes);
        return messageBuffer;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

