/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.transformers;

import java.text.SimpleDateFormat;
import org.mule.transformers.AbstractTransformer;
import org.ow2.jasmine.monitoring.eventswitch.messages.JasmineEvent;
import org.ow2.jasmine.monitoring.eventswitch.messages.JasmineEventDetails;

public class JasmineEventToString
extends AbstractTransformer {
    public JasmineEventToString() {
        this.registerSourceType(JasmineEvent.class);
        this.setReturnClass(String.class);
    }

    public Object doTransform(Object src, String encoding) {
        JasmineEvent event = (JasmineEvent)src;
        String result = "JASMINe Event object for " + event.getDomain() + "." + event.getServer() + " has " + event.getEvents().size() + " events:";
        for (JasmineEventDetails ed : event.getEvents()) {
            result = result + "\n\tProbe:  " + ed.getProbe() + "\n\tTime:   " + new SimpleDateFormat("MM/dd/yyyy, HH:mm:ss z").format(ed.getTimestamp()) + "\n\tValue:  " + ed.getValue() + "\n\t\t-----";
        }
        return result;
    }
}

