/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eventswitch.client;

import java.util.HashMap;
import java.util.Map;

import org.mule.umo.UMOException;
import org.ow2.jasmine.event.beans.JasmineEventNotification;
import org.ow2.jasmine.event.processor.JasmineEventNotificationProcessor;
import org.ow2.jasmine.event.processor.JasmineEventProcessorException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * Provide a processor that dispatches instances of {@link JasmineEventNotification}.
 * @author Jean-Pierre Poutcheu
 */
public class JasmineEventNotificationDispatcher implements JasmineEventNotificationProcessor<DispatcherContext> {

    /**
     * Logger.
     */
    private static Log logger = LogFactory.getLog(JasmineEventDispatcher.class);

    /**
     * Version of JASMINe event.
     */
    private static final String VERSION = "v1";

    /**
     * Properties to send with the dispatched events.
     */
    private final Map<String, String> messageProperties;

    /**
     * Build a new JASMINe event dispatcher.
     */
    public JasmineEventNotificationDispatcher() {
        messageProperties = new HashMap<String, String>();
        messageProperties.put("version", VERSION);
    }

    /**
     * Dispatch the given notification.
     * @param context a dispatcher context
     * @param event an notification to send
     * @throws JasmineEventProcessorException if Mule cannot dispatch the notification
     */
    private void dispatchEvent(DispatcherContext context, JasmineEventNotification event)
    throws JasmineEventProcessorException {
        try {
            context.getClient().dispatch(context.getJasmineURI(), event, messageProperties);
        } catch (UMOException e) {
            logger.error("Unable to send the notification at " + context.getJasmineURI(), e);
            throw new JasmineEventProcessorException(
                    "Unable to send the event at " + context.getJasmineURI(), e);
        }
    }

    /**
     * Process the given JASMINe event notification by dispatching it the Mule client.
     * @param context a dispatcher context
     * @param event an notification to process
     * @throws JasmineEventProcessorException if Mule cannot dispatch the event
     */
    public void process(DispatcherContext context, JasmineEventNotification event)
            throws JasmineEventProcessorException {
        dispatchEvent(context, event);
    }

}