/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.client;

import java.util.HashMap;
import java.util.Map;
import org.mule.umo.UMOException;
import org.ow2.jasmine.event.api.IJasmineEventNotification;
import org.ow2.jasmine.event.processor.JasmineEventNotificationProcessor;
import org.ow2.jasmine.event.processor.JasmineEventProcessorException;
import org.ow2.jasmine.monitoring.eventswitch.client.DispatcherContext;
import org.ow2.jasmine.monitoring.eventswitch.client.JasmineEventDispatcher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JasmineEventNotificationDispatcher
implements JasmineEventNotificationProcessor<DispatcherContext> {
    private static Log logger = LogFactory.getLog(JasmineEventDispatcher.class);
    private static final String VERSION = "v1";
    private final Map<String, String> messageProperties = new HashMap<String, String>();

    public JasmineEventNotificationDispatcher() {
        this.messageProperties.put("version", VERSION);
    }

    private void dispatchEvent(DispatcherContext context, IJasmineEventNotification event) throws JasmineEventProcessorException {
        try {
            context.getClient().dispatch(context.getJasmineURI(), (Object)event, this.messageProperties);
        }
        catch (UMOException e) {
            logger.error((Object)("Unable to send the notification at " + context.getJasmineURI()), new Object[]{e});
            throw new JasmineEventProcessorException("Unable to send the event at " + context.getJasmineURI(), (Throwable)e);
        }
    }

    public void process(DispatcherContext context, IJasmineEventNotification event) throws JasmineEventProcessorException {
        this.dispatchEvent(context, event);
    }
}

