/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.beans.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventEB;
import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventSLBRemote;
import org.ow2.jasmine.monitoring.eventswitch.beans.impl.JasmineEventEBImpl;

@Stateless
@Remote(value={JasmineEventSLBRemote.class})
public class JasmineEventSLBImpl
implements JasmineEventSLBRemote {
    @PersistenceContext
    private EntityManager entityManager = null;

    public void saveEvent(JasmineEventEB e) {
        JasmineEventEBImpl bean = new JasmineEventEBImpl();
        bean.setDomain(e.getDomain());
        bean.setServer(e.getServer());
        bean.setSource(e.getSource());
        bean.setProbe(e.getProbe());
        bean.setValue(e.getValue());
        bean.setTimestamp(e.getTimestamp());
        bean.setSname(e.getSname());
        this.entityManager.persist((Object)bean);
    }

    public JasmineEventEB[] getEvents(String domain, String server, String source, String probe, String value, Date startTimestamp, Date endTimestamp, String orderBy, int limit) {
        HashMap<String, Object> queryElements = new HashMap<String, Object>();
        queryElements.put("domain", domain);
        queryElements.put("server", server);
        queryElements.put("source", source);
        queryElements.put("probe", probe);
        queryElements.put("value", value);
        queryElements.put("startTimestamp", startTimestamp);
        queryElements.put("endTimestamp", endTimestamp);
        StringBuffer stringQuery = new StringBuffer("SELECT e FROM JasmineEventEBImpl e");
        for (String key : queryElements.keySet()) {
            if (queryElements.get(key) == null) continue;
            if (stringQuery.length() <= "SELECT e FROM JasmineEventEBImpl e".length()) {
                stringQuery.append(" WHERE ");
            } else {
                stringQuery.append(" OR ");
            }
            if (key.startsWith("start")) {
                stringQuery.append(("e." + key.charAt(5)).toLowerCase(Locale.ENGLISH));
                stringQuery.append(key.substring(6));
                stringQuery.append(" >= :");
            } else if (key.startsWith("end")) {
                stringQuery.append(("e." + key.charAt(3)).toLowerCase(Locale.ENGLISH));
                stringQuery.append(key.substring(4));
                stringQuery.append(" <= :");
            } else {
                stringQuery.append("e.");
                stringQuery.append(key);
                stringQuery.append(" LIKE :");
            }
            stringQuery.append(key);
        }
        if (orderBy != null) {
            stringQuery.append(" ORDER BY e.");
            stringQuery.append(orderBy);
            stringQuery.append(" ASC");
        }
        Query dbQuery = this.entityManager.createQuery(stringQuery.toString());
        dbQuery.setMaxResults(limit);
        for (String key : queryElements.keySet()) {
            if (queryElements.get(key) == null) continue;
            dbQuery.setParameter(key, queryElements.get(key));
        }
        List queryResult = dbQuery.getResultList();
        if (queryResult.size() < 1) {
            return null;
        }
        int i = 0;
        JasmineEventEB[] result = new JasmineEventEB[queryResult.size()];
        for (JasmineEventEBImpl bean : queryResult) {
            result[i++] = new JasmineEventEB(bean.getDomain(), bean.getServer(), bean.getSource(), bean.getProbe(), bean.getValue(), bean.getTimestamp(), bean.getSname());
        }
        return result;
    }
}

