/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineEventTimerEB.java 5569 2009-10-22 07:48:15Z ardaaydin $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eventswitch.beans.impl;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * Entity bean for a JASMINe Timer Event.
 */
@Entity
@Table(name = "JASMINE_EVENT_TIMER_SETTINGS")
public class JasmineEventTimerEB implements Serializable {

    private static final long serialVersionUID = 6640605662388109776L;

    /**
     * the primary key.
     */
    @Id
    private int id;

    private long maxEntryAge;

    private int maxEntryNumber;

    /**
     ** Notification date.
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "dateStamp")
    private Date executionStartDate;

    private int executionStartHours;

    private long executionInterval;

    private boolean immediateExecution;

    private boolean executeOnAllServers;

    private String domainName;

    private String serverName;

    /**
     * @return the maxEntryAge
     */
    public long getMaxEntryAge() {
        return maxEntryAge;
    }

    /**
     * @param maxEntryAge the maxEntryAge to set
     */
    public void setMaxEntryAge(final long maxEntryAge) {
        this.maxEntryAge = maxEntryAge;
    }

    /**
     * @return the maxEntryNumber
     */
    public int getMaxEntryNumber() {
        return maxEntryNumber;
    }

    /**
     * @param maxEntryNumber the maxEntryNumber to set
     */
    public void setMaxEntryNumber(final int maxEntryNumber) {
        this.maxEntryNumber = maxEntryNumber;
    }

    /**
     * @return the executionStartDate
     */
    public Date getExecutionStartDate() {
        return executionStartDate;
    }

    /**
     * @param executionStartDate the executionStartDate to set
     */
    public void setExecutionStartDate(final Date executionStartDate) {
        this.executionStartDate = executionStartDate;
    }

    /**
     * @return the executionStartHours
     */
    public int getExecutionStartHours() {
        return executionStartHours;
    }

    /**
     * @param executionStartHours the executionStartHours to set
     */
    public void setExecutionStartHours(final int executionStartHours) {
        this.executionStartHours = executionStartHours;
    }

    /**
     * @return the executionInterval
     */
    public long getExecutionInterval() {
        return executionInterval;
    }

    /**
     * @param executionInterval the executionInterval to set
     */
    public void setExecutionInterval(final long executionInterval) {
        this.executionInterval = executionInterval;
    }

    /**
     * @return the immediateExecution
     */
    public boolean isImmediateExecution() {
        return immediateExecution;
    }

    /**
     * @param immediateExecution the immediateExecution to set
     */
    public void setImmediateExecution(final boolean immediateExecution) {
        this.immediateExecution = immediateExecution;
    }

    /**
     * @return the executeOnAllServers
     */
    public boolean isExecuteOnAllServers() {
        return executeOnAllServers;
    }

    /**
     * @param executeOnAllServers the executeOnAllServers to set
     */
    public void setExecuteOnAllServers(final boolean executeOnAllServers) {
        this.executeOnAllServers = executeOnAllServers;
    }

    /**
     * @return the domainName
     */
    public String getDomainName() {
        return domainName;
    }

    /**
     * @param domainName the domainName to set
     */
    public void setDomainName(final String domainName) {
        this.domainName = domainName;
    }

    /**
     * @return the serverName
     */
    public String getServerName() {
        return serverName;
    }

    /**
     * @param serverName the serverName to set
     */
    public void setServerName(final String serverName) {
        this.serverName = serverName;
    }

    /**
     * @return the serialVersionUID
     */
    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    /**
     * @return the id
     */
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(final int id) {
        this.id = id;
    }

}
