/**
 * JASMINe
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineEventEBImpl.java 1928 2008-07-30 08:45:19Z loris $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eventswitch.beans.impl;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * Entity bean for a JASMINe Event.
 */
@Entity
@Table(name = "JASMINE_EVENTS")
public class JasmineEventEBImpl implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 3603043818875621406L;

    /**
     * Primary key.
     */
    private Long id;
    
    /**
     * Domain of the probed server.
     */
    private String domain;

    /**
     * Name of the probed server.
     */
    private String server;

    /**
     * Event source (for example, MBeanCmd or JMX).
     */
    private String source;

    /**
     * Probe type.
     */
    private String probe;

    /**
     * Probed value.
     */
    private String value;

    /**
     * Probe time (precise up to a second).
     */
    private Date timestamp;

    /**
     * JMX url of the probe.
     */
    private String sname;
    
    // ------------------------------------------------------------------------
    // Default constructor
    // ------------------------------------------------------------------------
    
    public JasmineEventEBImpl() {
    }

    // ------------------------------------------------------------------------
    // Getters & setters
    // ------------------------------------------------------------------------
    
    /**
     * @return Primary key
     */
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="JasmineEventSeq")
    @SequenceGenerator(name="JasmineEventSeq",sequenceName="JASMINE_EVENT_SEQ", allocationSize=1)
    public Long getId() {
        return id;
    }
    
    /**
     * @param id Primary key
     */
    public void setId(final Long id) {
        this.id = id;
    }

    /**
     * @return  Domain of the probed server.
     */
    public String getDomain() {
        return domain;
    }

    /**
     * @param domain  Domain of the probed server.
     */
    public void setDomain(final String domain) {
        this.domain = domain;
    }

    /**
     * @return  Name of the probed server.
     */
    public String getServer() {
        return server;
    }

    /**
     * @param server  Name of the probed server.
     */
    public void setServer(final String server) {
        this.server = server;
    }

    /**
     * @return  Event source (for example, MBeanCmd or JMX).
     */
    public String getSource() {
        return source;
    }

    /**
     * @param source  Event source (for example, MBeanCmd or JMX).
     */
    public void setSource(final String source) {
        this.source = source;
    }

    /**
     * @return  Probe type.
     */
    public String getProbe() {
        return probe;
    }

    /**
     * @param probe  Probe type.
     */
    public void setProbe(final String probe) {
        this.probe = probe;
    }

    /**
     * @return  Probed value.
     */
    public String getValue() {
        return value;
    }

    /**
     * @param value  Probed value.
     */
    public void setValue(final String value) {
        this.value = value;
    }

    /**
     * @return  Probe time (precise up to a second).
     */
    @Temporal(TemporalType.TIMESTAMP)
    public Date getTimestamp() {
        return timestamp;
    }

    /**
     * @param timestamp  Probe time (precise up to a second).
     */
    public void setTimestamp(final Date timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * @return JMX url of the probe.
     */
    public String getSname() {
        return sname;
    }

    /**
     * @param sname JMX url of the probe.
     */
    public void setSname(String sname) {
        this.sname = sname;
    }
}
