/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.beans.impl;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.ow2.jasmine.event.messages.JasmineEventTimer;
import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventTimerSLBRemote;
import org.ow2.jasmine.monitoring.eventswitch.beans.impl.JasmineEventEBImpl;
import org.ow2.jasmine.monitoring.eventswitch.beans.impl.JasmineEventTimerEB;

@Stateless(mappedName="db-ejb/timer")
@Remote(value={JasmineEventTimerSLBRemote.class})
public class JasmineEventTimerSLBImpl
implements JasmineEventTimerSLBRemote {
    static final String EVENT_CLASS_NAME = JasmineEventEBImpl.class.getName();
    Logger logger = Logger.getLogger(this.getClass().getName());
    private static final int FIXED_UNIQUE_ID = 1;
    @Resource
    private SessionContext sessionContext;
    TimerService timerService = null;
    Timer currentTimer = null;
    @PersistenceContext
    private EntityManager entityManager = null;
    JasmineEventTimerEB bean = new JasmineEventTimerEB();

    @PostConstruct
    private void getTimerService() {
        this.timerService = this.sessionContext.getTimerService();
    }

    private void loadTimerEB() {
        this.bean = (JasmineEventTimerEB)this.entityManager.find(JasmineEventTimerEB.class, (Object)0);
    }

    private void saveTimerEB() {
        this.entityManager.persist((Object)this.bean);
    }

    private void createTimer() {
        this.clearOldTimers();
        if (this.bean.getExecutionInterval() > 0L) {
            this.currentTimer = this.timerService.createTimer(this.bean.getExecutionStartDate(), this.bean.getExecutionInterval(), (Serializable)((Object)""));
            this.logger.info("[PurgeTimer]Timer configured, first execution : " + this.bean.getExecutionStartDate().toString());
        } else {
            this.logger.warning("Timer Interval must be greater than zero.");
        }
    }

    private void clearOldTimers() {
        Collection timersCollection = this.timerService.getTimers();
        for (Timer timer : timersCollection) {
            timer.cancel();
        }
        timersCollection.clear();
    }

    public int configureTimer(JasmineEventTimer e) {
        this.logger.fine("------------------------------------\n\n\n");
        this.logger.fine(" Event Received with attributes:");
        this.logger.fine(" - MaxEntryAge :" + e.getMaxEntryAge());
        this.logger.fine(" - MaxEntryNumber :" + e.getMaxEntryNumber());
        this.logger.fine(" - ImmediateExecution :" + e.isImmediateExecution());
        this.logger.fine(" - ExecuteOnAllServers :" + e.isExecuteOnAllServers());
        this.logger.fine(" - DomainName :" + e.getDomainName());
        this.logger.fine(" - ServerName :" + e.getServerName());
        this.logger.fine(" - ExecutionStartDate :" + e.getExecutionStartDate());
        this.logger.fine(" - ExecutionStartHours :" + e.getExecutionStartHours());
        this.logger.fine(" - ExecutionInterval :" + e.getExecutionInterval());
        this.logger.fine("\n\n\n------------------------------------");
        this.bean.setId(1);
        this.bean.setMaxEntryAge(e.getMaxEntryAge());
        this.bean.setMaxEntryNumber(e.getMaxEntryNumber());
        this.bean.setImmediateExecution(e.isImmediateExecution());
        this.bean.setExecuteOnAllServers(e.isExecuteOnAllServers());
        if (!e.isExecuteOnAllServers()) {
            this.bean.setDomainName(e.getDomainName());
            this.bean.setServerName(e.getServerName());
        }
        if (e.isImmediateExecution()) {
            this.deleteEventsFromDB();
        } else {
            this.bean.setExecutionStartDate(e.getExecutionStartDate());
            this.bean.setExecutionInterval(e.getExecutionInterval());
            this.createTimer();
        }
        return 1;
    }

    private void deleteEventsFromDB() {
        Long maxNumber = new Long(this.bean.getMaxEntryNumber());
        StringBuilder stringQueryMax = new StringBuilder();
        stringQueryMax.append("Select max(e.id) from ").append(EVENT_CLASS_NAME).append(" e");
        Query dbQueryMax = this.entityManager.createQuery(stringQueryMax.toString());
        Long maxPrimaryKeyId = (Long)dbQueryMax.getSingleResult();
        if (maxPrimaryKeyId != null) {
            Long minPrimaryKeyId = maxPrimaryKeyId - maxNumber;
            Calendar cal = Calendar.getInstance();
            Date endDate = cal.getTime();
            long timeDiff = this.bean.getMaxEntryAge();
            Date startDate = new Date(endDate.getTime() - timeDiff);
            StringBuilder stringQuery = new StringBuilder();
            if (maxNumber != -1L) {
                stringQuery.append("DELETE FROM ").append(EVENT_CLASS_NAME).append(" e").append(" WHERE (e.id NOT BETWEEN :min AND :max)");
            } else {
                stringQuery.append("DELETE FROM ").append(EVENT_CLASS_NAME).append(" e").append(" WHERE (e.timestamp NOT BETWEEN :start AND :end)");
            }
            if (!this.bean.isExecuteOnAllServers()) {
                stringQuery.append(" AND (e.domain=:domain AND e.server=:server)");
            }
            Query dbQuery = this.entityManager.createQuery(stringQuery.toString());
            this.logger.fine(" - Query to db : " + dbQuery.toString());
            this.logger.fine(" - Query to min : " + minPrimaryKeyId);
            this.logger.fine(" - Query to max : " + maxPrimaryKeyId);
            this.logger.fine(" - Query to start : " + startDate);
            this.logger.fine(" - Query to end : " + endDate);
            if (this.bean.isExecuteOnAllServers()) {
                if (maxNumber != -1L) {
                    dbQuery.setParameter("min", (Object)minPrimaryKeyId).setParameter("max", (Object)maxPrimaryKeyId);
                } else {
                    dbQuery.setParameter("start", (Object)startDate).setParameter("end", (Object)endDate);
                }
            } else if (maxNumber != -1L) {
                dbQuery.setParameter("min", (Object)minPrimaryKeyId).setParameter("max", (Object)maxPrimaryKeyId).setParameter("domain", (Object)this.bean.getDomainName()).setParameter("server", (Object)this.bean.getServerName());
            } else {
                dbQuery.setParameter("start", (Object)startDate).setParameter("end", (Object)endDate).setParameter("domain", (Object)this.bean.getDomainName()).setParameter("server", (Object)this.bean.getServerName());
            }
            int result = dbQuery.executeUpdate();
            this.logger.info("[PurgeTimer]Event Timer cleaned up " + result + " events ");
        } else {
            this.logger.info("[PurgeTimer]No events to delete in database");
        }
    }

    @Timeout
    public void handleTimeout(Timer timer) {
        this.deleteEventsFromDB();
        Calendar cal = Calendar.getInstance();
        this.logger.info("[PurgeTimer]Timer triggered");
    }
}

