/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.beans.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.ow2.jasmine.event.beans.JasmineEventNotification;
import org.ow2.jasmine.event.beans.JasmineEventNotificationDetail;
import org.ow2.jasmine.event.beans.JasmineEventNotificationExecutedAction;
import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventNotificationSLBRemote;
import org.ow2.jasmine.monitoring.eventswitch.beans.impl.JasmineEventDetailEB;
import org.ow2.jasmine.monitoring.eventswitch.beans.impl.JasmineEventNotificationActionEBImpl;
import org.ow2.jasmine.monitoring.eventswitch.beans.impl.JasmineEventNotificationEBImpl;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless(mappedName="db-ejb/notification")
@Remote(value={JasmineEventNotificationSLBRemote.class})
public class JasmineEventNotificationSLBImpl
implements JasmineEventNotificationSLBRemote {
    @PersistenceContext
    private EntityManager entityManager = null;

    public void saveExecutedAction(String id, JasmineEventNotificationExecutedAction action) {
        JasmineEventNotificationEBImpl notif = (JasmineEventNotificationEBImpl)this.entityManager.find(JasmineEventNotificationEBImpl.class, (Object)id);
        JasmineEventNotificationActionEBImpl actionEB = new JasmineEventNotificationActionEBImpl(action.getComment(), action.getAction(), action.getDate(), action.getUser());
        actionEB.setNotification(notif);
        notif.addAction(actionEB);
    }

    public void updateNotificationStatus(String id, boolean status) {
        JasmineEventNotificationEBImpl notif = (JasmineEventNotificationEBImpl)this.entityManager.find(JasmineEventNotificationEBImpl.class, (Object)id);
        notif.setStatus(status);
    }

    public void saveEvent(JasmineEventNotification n) {
        try {
            JasmineEventNotificationEBImpl bean = new JasmineEventNotificationEBImpl();
            ArrayList<JasmineEventDetailEB> details = new ArrayList<JasmineEventDetailEB>();
            ArrayList<JasmineEventNotificationActionEBImpl> actions = new ArrayList<JasmineEventNotificationActionEBImpl>();
            bean.setId(n.getId());
            bean.setDate(n.getDate());
            bean.setLevel(n.getLevel());
            bean.setMessage(n.getMessage());
            bean.setRule(n.getRule());
            bean.setStatus(n.getStatus());
            if (!n.getDetails().isEmpty()) {
                for (JasmineEventNotificationDetail entry : n.getDetails()) {
                    JasmineEventDetailEB detail = new JasmineEventDetailEB(entry.getLabel(), entry.getMessage());
                    detail.setNotification(bean);
                    details.add(detail);
                }
                bean.setDetails(details);
            }
            if (!n.getActions().isEmpty()) {
                for (JasmineEventNotificationDetail entry : n.getActions()) {
                    JasmineEventNotificationActionEBImpl action = new JasmineEventNotificationActionEBImpl(entry.getComment(), entry.getAction(), entry.getDate(), entry.getUser());
                    action.setNotification(bean);
                    actions.add(action);
                }
                bean.setActions(actions);
            }
            this.entityManager.persist((Object)bean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JasmineEventNotification[] getEventNotifications(String id, Date date, String level, String message, Boolean status, String rule, String orderBy, Integer limit) {
        HashMap<String, Object> queryElements = new HashMap<String, Object>();
        queryElements.put("id", id);
        queryElements.put("date", date);
        queryElements.put("level", level);
        queryElements.put("message", message);
        queryElements.put("status", status);
        queryElements.put("rule", rule);
        StringBuilder stringQuery = new StringBuilder("SELECT e FROM JasmineEventNotificationEBImpl e");
        for (String key : queryElements.keySet()) {
            if (queryElements.get(key) == null) continue;
            if (stringQuery.length() > "SELECT e FROM JasmineEventNotificationEBImpl e".length()) {
                stringQuery.append(" AND ");
            } else {
                stringQuery.append(" WHERE ");
            }
            stringQuery.append("e.");
            stringQuery.append(key);
            stringQuery.append(" LIKE :");
            stringQuery.append(key);
        }
        if (orderBy != null) {
            stringQuery.append(" ORDER BY e.");
            stringQuery.append(orderBy);
            stringQuery.append(" ASC");
        }
        Query dbQuery = this.entityManager.createQuery(stringQuery.toString());
        if (limit != null) {
            dbQuery.setMaxResults(limit.intValue());
        }
        for (String key : queryElements.keySet()) {
            if (queryElements.get(key) == null) continue;
            dbQuery.setParameter(key, queryElements.get(key));
        }
        LogFactory.getLog(this.getClass()).debug((Object)"Executing the following query : \n\t{0}", new Object[]{stringQuery});
        List queryResult = dbQuery.getResultList();
        if (queryResult.size() < 1) {
            return null;
        }
        int i = 0;
        JasmineEventNotification[] result = new JasmineEventNotification[queryResult.size()];
        for (JasmineEventNotificationEBImpl bean : queryResult) {
            JasmineEventNotification notificationResult = new JasmineEventNotification(bean.getId(), bean.getDate(), bean.getLevel(), bean.getMessage(), bean.getStatus(), bean.getRule());
            notificationResult.setDetails(bean.getNotificationDetails());
            notificationResult.setActions(bean.getActions());
            result[i++] = notificationResult;
        }
        return result;
    }

    public List<JasmineEventNotification> getEventNotifications(Date dateFrom, Date dateTo) {
        LogFactory.getLog(this.getClass()).debug((Object)"Query dateFrom {0} to dateTo {1}", new Object[]{dateFrom, dateTo});
        StringBuilder stringQuery = new StringBuilder("SELECT e FROM JasmineEventNotificationEBImpl e");
        stringQuery.append(" WHERE ");
        stringQuery.append(" e.date >= :dateFrom AND e.date <= :dateTo");
        Query dbQuery = this.entityManager.createQuery(stringQuery.toString());
        dbQuery.setParameter("dateFrom", (Object)dateFrom);
        dbQuery.setParameter("dateTo", (Object)dateTo);
        List queryResult = dbQuery.getResultList();
        ArrayList<JasmineEventNotification> result = new ArrayList<JasmineEventNotification>();
        if (queryResult.size() < 1) {
            LogFactory.getLog(this.getClass()).debug((Object)"No result found for the following query : \n\t{0}", new Object[]{stringQuery});
            return null;
        }
        for (JasmineEventNotificationEBImpl bean : queryResult) {
            JasmineEventNotification notificationResult = new JasmineEventNotification(bean.getId(), bean.getDate(), bean.getLevel(), bean.getMessage(), bean.getStatus(), bean.getRule());
            notificationResult.setDetails(bean.getNotificationDetails());
            notificationResult.setActions(bean.getActions());
            result.add(notificationResult);
        }
        return result;
    }

    public List<JasmineEventNotification> getEventNotifications(String ... rulePattern) {
        LogFactory.getLog(this.getClass()).debug((Object)"Getting notification matching rule patterns", new Object[0]);
        StringBuilder stringQuery = new StringBuilder("SELECT e FROM JasmineEventNotificationEBImpl e");
        for (int i = 0; i < rulePattern.length; ++i) {
            if (i == 0) {
                stringQuery.append(" WHERE ");
            } else {
                stringQuery.append(" OR ");
            }
            stringQuery.append("e.rule LIKE :rulePattern");
            stringQuery.append(i);
        }
        Query dbQuery = this.entityManager.createQuery(stringQuery.toString());
        for (int i = 0; i < rulePattern.length; ++i) {
            dbQuery.setParameter("rulePattern" + i, (Object)rulePattern[i].replace("*", "%%"));
        }
        List queryResult = dbQuery.getResultList();
        ArrayList<JasmineEventNotification> result = new ArrayList<JasmineEventNotification>();
        if (queryResult.size() < 1) {
            LogFactory.getLog(this.getClass()).debug((Object)"No result found for the following query : \n\t{0}", new Object[]{stringQuery});
            return null;
        }
        for (JasmineEventNotificationEBImpl bean : queryResult) {
            JasmineEventNotification notificationResult = new JasmineEventNotification(bean.getId(), bean.getDate(), bean.getLevel(), bean.getMessage(), bean.getStatus(), bean.getRule());
            notificationResult.setDetails(bean.getNotificationDetails());
            notificationResult.setActions(bean.getActions());
            result.add(notificationResult);
        }
        return result;
    }

    public List<JasmineEventNotification> getAllNotifications() {
        LogFactory.getLog(this.getClass()).debug((Object)"Getting all the notifications from the DataBase", new Object[0]);
        String stringQuery = "SELECT e FROM JasmineEventNotificationEBImpl e";
        Query dbQuery = this.entityManager.createQuery(stringQuery);
        List queryResult = dbQuery.getResultList();
        ArrayList<JasmineEventNotification> result = new ArrayList<JasmineEventNotification>();
        if (queryResult.size() < 1) {
            LogFactory.getLog(this.getClass()).debug((Object)"No result found for the following query : \n\t{0}", new Object[]{stringQuery});
            return null;
        }
        for (JasmineEventNotificationEBImpl bean : queryResult) {
            JasmineEventNotification notificationResult = new JasmineEventNotification(bean.getId(), bean.getDate(), bean.getLevel(), bean.getMessage(), bean.getStatus(), bean.getRule());
            notificationResult.setDetails(bean.getNotificationDetails());
            notificationResult.setActions(bean.getActions());
            result.add(notificationResult);
        }
        return result;
    }

    public JasmineEventNotification getEventNotification(String id) {
        JasmineEventNotificationEBImpl bean = (JasmineEventNotificationEBImpl)this.entityManager.find(JasmineEventNotificationEBImpl.class, (Object)id);
        JasmineEventNotification notificationResult = new JasmineEventNotification(bean.getId(), bean.getDate(), bean.getLevel(), bean.getMessage(), bean.getStatus(), bean.getRule());
        notificationResult.setDetails(bean.getNotificationDetails());
        notificationResult.setActions(bean.getActions());
        return notificationResult;
    }
}

