/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineEventNotificationActionEBImpl.java 4887 2009-08-12 14:52:21Z hant $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.monitoring.eventswitch.beans.impl;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name = "JASMINE_EVENT_NOTIFICATIONS_ACTIONS")
public class JasmineEventNotificationActionEBImpl implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = -5337125420746859697L;

    /**
     * Primary key.
     */
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;

    /**
     * Comment for the action.
     */
    private String comment = null;

    /**
     * Name of the executed action.
     */
    private String action = null;

    /**
     * Date of the time action.
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "dateStamp")
    private Date date = null;

    /**
     * The user who executed the action.
     */
    @Column(name = "username")
    private String user = null;

    /**
     * notification parent.
     */
    @ManyToOne(cascade = CascadeType.ALL)
    @JoinColumn(name = "NOTIFICATION_ID", nullable = false)
    private JasmineEventNotificationEBImpl notification = null;

    /**
     * Default Constructor
     */
    public JasmineEventNotificationActionEBImpl() {
        super();
    }

    /**
     * Constructor using fields ...
     *
     * @param comment Comment of the user that executed the action.
     * @param action Action executed
     * @param date Date when the action was executed
     */
    public JasmineEventNotificationActionEBImpl(final String comment, final String action, final Date date, final String user) {
        super();
        this.comment = comment;
        this.action = action;
        this.date = date;
        this.user = user;
    }

    /**
     * @return Primary key
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id Primary key
     */
    public void setId(final Long id) {
        this.id = id;
    }

    /**
     * @return the comment
     */
    public String getComment() {
        return comment;
    }

    /**
     * @param comment the comment to set
     */
    public void setComment(final String comment) {
        this.comment = comment;
    }

    /**
     * @return the action
     */
    public String getAction() {
        return action;
    }

    /**
     * @param action the action to set
     */
    public void setAction(final String action) {
        this.action = action;
    }

    /**
     * @return the date
     */
    @Column(name = "dateStamp")
    public Date getDate() {
        return date;
    }

    /**
     * @param date the date to set
     */
    @Column(name = "dateStamp")
    public void setDate(final Date date) {
        this.date = date;
    }

    /**
     * @return the notification
     */
    public JasmineEventNotificationEBImpl getNotification() {
        return notification;
    }

    /**
     * @param notification the notification to set
     */
    public void setNotification(final JasmineEventNotificationEBImpl notification) {
        this.notification = notification;
    }

    /**
     * @return the user
     */
    @Column(name = "username")
    public String getUser() {
        return user;
    }

    /**
     * @param user the user to set
     */
    @Column(name = "username")
    public void setUser(final String user) {
        this.user = user;
    }

}
