/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.beans.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.ow2.jasmine.event.beans.JasmineEventNotification;
import org.ow2.jasmine.event.beans.JasmineEventNotificationDetail;
import org.ow2.jasmine.event.beans.JasmineEventNotificationExecutedAction;
import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventNotificationSLBRemote;
import org.ow2.jasmine.monitoring.eventswitch.beans.impl.JasmineEventDetailEB;
import org.ow2.jasmine.monitoring.eventswitch.beans.impl.JasmineEventNotificationActionEBImpl;
import org.ow2.jasmine.monitoring.eventswitch.beans.impl.JasmineEventNotificationEBImpl;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless(mappedName="db-ejb/notification")
@Remote(value={JasmineEventNotificationSLBRemote.class})
public class JasmineEventNotificationSLBImpl
implements JasmineEventNotificationSLBRemote {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final long HOURS_TO_MILLISECONDS = 3600000L;
    @PersistenceContext(unitName="persistence-unit/notification")
    private EntityManager entityManager = null;

    public void saveExecutedAction(String id, JasmineEventNotificationExecutedAction action) {
        JasmineEventNotificationEBImpl notif = (JasmineEventNotificationEBImpl)this.entityManager.find(JasmineEventNotificationEBImpl.class, (Object)id);
        JasmineEventNotificationActionEBImpl actionEB = new JasmineEventNotificationActionEBImpl(action.getComment(), action.getAction(), action.getDate(), action.getUser());
        actionEB.setNotification(notif);
        notif.addAction(actionEB);
    }

    public void updateNotificationStatus(String id, boolean status) {
        JasmineEventNotificationEBImpl notif = (JasmineEventNotificationEBImpl)this.entityManager.find(JasmineEventNotificationEBImpl.class, (Object)id);
        notif.setStatus(status);
    }

    public void saveEvent(JasmineEventNotification n) {
        JasmineEventNotificationEBImpl bean = new JasmineEventNotificationEBImpl();
        ArrayList<JasmineEventDetailEB> details = new ArrayList<JasmineEventDetailEB>();
        ArrayList<JasmineEventNotificationActionEBImpl> actions = new ArrayList<JasmineEventNotificationActionEBImpl>();
        bean.setId(n.getId());
        bean.setDate(n.getDate());
        bean.setLevel(n.getLevel());
        bean.setMessage(n.getMessage());
        bean.setRule(n.getRule());
        bean.setStatus(n.getStatus());
        if (!n.getDetails().isEmpty()) {
            for (JasmineEventNotificationDetail entry : n.getDetails()) {
                JasmineEventDetailEB detail = new JasmineEventDetailEB(entry.getLabel(), entry.getMessage());
                detail.setNotification(bean);
                details.add(detail);
            }
            bean.setDetails(details);
        }
        if (!n.getActions().isEmpty()) {
            for (JasmineEventNotificationDetail entry : n.getActions()) {
                JasmineEventNotificationActionEBImpl action = new JasmineEventNotificationActionEBImpl(entry.getComment(), entry.getAction(), entry.getDate(), entry.getUser());
                action.setNotification(bean);
                actions.add(action);
            }
            bean.setActions(actions);
        }
        this.entityManager.persist((Object)bean);
    }

    public List<JasmineEventNotification> getEventNotifications(int keepDisplayed, String acknowledgeButtonName, String ... rules) {
        this.logger.debug((Object)("getEventNotifications(" + keepDisplayed + ", {0}, {1})"), new Object[]{acknowledgeButtonName, rules});
        if (rules == null || rules.length == 0) {
            throw new IllegalArgumentException("No rules specified!");
        }
        StringBuilder stringQuery = new StringBuilder("SELECT e FROM JasmineEventNotificationEBImpl e WHERE (");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int i = 0; i < rules.length; ++i) {
            String rule = rules[i];
            if (i != 0) {
                stringQuery.append(" OR ");
            }
            stringQuery.append("e.rule LIKE :rule" + i);
            if (rule.startsWith("*")) {
                rule = "%%" + rule.substring(1);
            } else if (rule.endsWith("*")) {
                rule = rule.substring(0, rule.length() - 1) + "%%";
            }
            parameters.put("rule" + i, rule);
        }
        stringQuery.append(") ");
        long keepDisplayedInMilliseconds = keepDisplayed;
        Date keepDisplayedHoursAgo = new Date(System.currentTimeMillis() - (keepDisplayedInMilliseconds *= 3600000L));
        parameters.put("date", keepDisplayedHoursAgo);
        stringQuery.append(" AND ");
        if (acknowledgeButtonName == null) {
            stringQuery.append("e.date > :date");
        } else {
            stringQuery.append("(e.status = false OR (e.status = true AND (");
            stringQuery.append("SELECT COUNT(*) FROM JasmineEventNotificationActionEBImpl a WHERE ");
            stringQuery.append("a.notification = e AND a.date < :date AND a.action = :action");
            stringQuery.append(") = 0))");
            parameters.put("action", acknowledgeButtonName);
        }
        this.logger.debug((Object)"executing DB query {0}, parameters {1}", new Object[]{stringQuery, parameters});
        Query dbQuery = this.entityManager.createQuery(stringQuery.toString());
        for (Map.Entry parameter : parameters.entrySet()) {
            dbQuery.setParameter((String)parameter.getKey(), parameter.getValue());
        }
        List queryResult = dbQuery.getResultList();
        ArrayList<JasmineEventNotification> result = new ArrayList<JasmineEventNotification>();
        for (JasmineEventNotificationEBImpl bean : queryResult) {
            JasmineEventNotification notificationResult = new JasmineEventNotification(bean.getId(), bean.getDate(), bean.getLevel(), bean.getMessage(), bean.getStatus(), bean.getRule());
            notificationResult.setDetails(bean.getNotificationDetails());
            notificationResult.setActions(bean.getActions());
            result.add(notificationResult);
        }
        this.logger.debug((Object)"getEventNotifications returns {0}", new Object[]{result});
        return result;
    }

    public List<JasmineEventNotification> getEventNotifications(Date dateFrom, Date dateTo) {
        this.logger.debug((Object)"getEventNotifications({0}, {1})", new Object[]{dateFrom, dateTo});
        StringBuilder stringQuery = new StringBuilder("SELECT e FROM JasmineEventNotificationEBImpl e");
        stringQuery.append(" WHERE ");
        stringQuery.append(" e.date >= :dateFrom AND e.date <= :dateTo");
        Query dbQuery = this.entityManager.createQuery(stringQuery.toString());
        dbQuery.setParameter("dateFrom", (Object)dateFrom);
        dbQuery.setParameter("dateTo", (Object)dateTo);
        List queryResult = dbQuery.getResultList();
        ArrayList<JasmineEventNotification> result = new ArrayList<JasmineEventNotification>();
        for (JasmineEventNotificationEBImpl bean : queryResult) {
            JasmineEventNotification notificationResult = new JasmineEventNotification(bean.getId(), bean.getDate(), bean.getLevel(), bean.getMessage(), bean.getStatus(), bean.getRule());
            notificationResult.setDetails(bean.getNotificationDetails());
            notificationResult.setActions(bean.getActions());
            result.add(notificationResult);
        }
        this.logger.debug((Object)"getEventNotifications returns {0}", new Object[]{result});
        return result;
    }

    public JasmineEventNotification[] getEventNotifications(String id, Date date, String level, String message, Boolean status, String rule, String orderBy, Integer limit) {
        this.logger.debug((Object)"getEventNotifications({0}, {1}, {2}, {3}, {4}, {5}, {6}, {7})", new Object[]{id, date, level, message, status, rule, orderBy, limit});
        HashMap<String, Object> queryElements = new HashMap<String, Object>();
        queryElements.put("id", id);
        queryElements.put("date", date);
        queryElements.put("level", level);
        queryElements.put("message", message);
        queryElements.put("status", status);
        queryElements.put("rule", rule);
        StringBuilder stringQuery = new StringBuilder("SELECT e FROM JasmineEventNotificationEBImpl e");
        boolean WHERE = true;
        for (String key : queryElements.keySet()) {
            if (queryElements.get(key) == null) continue;
            if (WHERE) {
                WHERE = false;
                stringQuery.append(" WHERE ");
            } else {
                stringQuery.append(" AND ");
            }
            stringQuery.append("e.");
            stringQuery.append(key);
            stringQuery.append(" LIKE :");
            stringQuery.append(key);
        }
        if (orderBy != null) {
            stringQuery.append(" ORDER BY e.");
            stringQuery.append(orderBy);
            stringQuery.append(" ASC");
        }
        Query dbQuery = this.entityManager.createQuery(stringQuery.toString());
        if (limit != null) {
            dbQuery.setMaxResults(limit.intValue());
        }
        for (String key : queryElements.keySet()) {
            if (queryElements.get(key) == null) continue;
            dbQuery.setParameter(key, queryElements.get(key));
        }
        this.logger.debug((Object)"executing DB query {0}, parameters {1}", new Object[]{stringQuery, queryElements});
        List queryResult = dbQuery.getResultList();
        if (queryResult.size() < 1) {
            return null;
        }
        int i = 0;
        JasmineEventNotification[] result = new JasmineEventNotification[queryResult.size()];
        for (JasmineEventNotificationEBImpl bean : queryResult) {
            JasmineEventNotification notificationResult = new JasmineEventNotification(bean.getId(), bean.getDate(), bean.getLevel(), bean.getMessage(), bean.getStatus(), bean.getRule());
            notificationResult.setDetails(bean.getNotificationDetails());
            notificationResult.setActions(bean.getActions());
            result[i++] = notificationResult;
        }
        return result;
    }

    public List<JasmineEventNotification> getAllNotifications() {
        this.logger.debug((Object)"Getting all the notifications from the DataBase", new Object[0]);
        String stringQuery = "SELECT e FROM JasmineEventNotificationEBImpl e";
        Query dbQuery = this.entityManager.createQuery(stringQuery);
        List queryResult = dbQuery.getResultList();
        ArrayList<JasmineEventNotification> result = new ArrayList<JasmineEventNotification>();
        for (JasmineEventNotificationEBImpl bean : queryResult) {
            JasmineEventNotification notificationResult = new JasmineEventNotification(bean.getId(), bean.getDate(), bean.getLevel(), bean.getMessage(), bean.getStatus(), bean.getRule());
            notificationResult.setDetails(bean.getNotificationDetails());
            notificationResult.setActions(bean.getActions());
            result.add(notificationResult);
        }
        return result;
    }

    public JasmineEventNotification getEventNotification(String id) {
        JasmineEventNotificationEBImpl bean = (JasmineEventNotificationEBImpl)this.entityManager.find(JasmineEventNotificationEBImpl.class, (Object)id);
        JasmineEventNotification notificationResult = new JasmineEventNotification(bean.getId(), bean.getDate(), bean.getLevel(), bean.getMessage(), bean.getStatus(), bean.getRule());
        notificationResult.setDetails(bean.getNotificationDetails());
        notificationResult.setActions(bean.getActions());
        return notificationResult;
    }
}

