/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.beans.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.ow2.jasmine.event.beans.JasmineEventEB;
import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventSLBRemote;
import org.ow2.jasmine.monitoring.eventswitch.beans.impl.JasmineEventEBImpl;

@Stateless(mappedName="db-ejb/event")
@Remote(value={JasmineEventSLBRemote.class})
public class JasmineEventSLBImpl
implements JasmineEventSLBRemote {
    static final String EVENT_CLASS_NAME = JasmineEventEBImpl.class.getName();
    @PersistenceContext(unitName="persistence-unit/event")
    private EntityManager entityManager = null;

    public void saveEvent(JasmineEventEB e) {
        JasmineEventEBImpl bean = new JasmineEventEBImpl();
        bean.setDomain(e.getDomain());
        bean.setServer(e.getServer());
        bean.setSource(e.getSource());
        bean.setProbe(e.getProbe());
        bean.setValue(e.getValue().toString());
        bean.setTimestamp(e.getTimestamp());
        bean.setSname(e.getSname());
        this.entityManager.persist((Object)bean);
    }

    public JasmineEventEB[] getEvents(String domain, String server, String source, String probe, String value, Date startTimestamp, Date endTimestamp, String orderBy, int limit) {
        return this.getEvents(domain, server, source, probe, value, startTimestamp, endTimestamp, orderBy, 0, limit);
    }

    public JasmineEventEB[] getEvents(String domain, String server, String source, String probe, String value, Date startTimestamp, Date endTimestamp, String orderBy, int indexFirstResult, int limit) {
        HashMap<String, Date> map;
        HashMap<String, String> map2;
        StringBuilder nameCriterion;
        int i;
        HashMap groupsCriteria = new HashMap();
        String separator = "separator";
        if (domain != null && !domain.equals("")) {
            String[] domains = domain.split(separator);
            HashMap<String, String> domainCriteria = new HashMap<String, String>();
            for (i = 0; i < domains.length; ++i) {
                nameCriterion = new StringBuilder("domain").append(i);
                domainCriteria.put(nameCriterion.toString(), domains[i]);
            }
            groupsCriteria.put("domain", domainCriteria);
        }
        if (server != null && !server.equals("")) {
            String[] servers = server.split(separator);
            map2 = new HashMap<String, String>();
            for (i = 0; i < servers.length; ++i) {
                nameCriterion = new StringBuilder("server").append(i);
                map2.put(nameCriterion.toString(), servers[i]);
            }
            groupsCriteria.put("server", map2);
        }
        if (source != null && !source.equals("")) {
            String[] sources = source.split(separator);
            map2 = new HashMap();
            for (i = 0; i < sources.length; ++i) {
                nameCriterion = new StringBuilder("source").append(i);
                map2.put(nameCriterion.toString(), sources[i]);
            }
            groupsCriteria.put("source", map2);
        }
        if (probe != null && !probe.equals("")) {
            String[] probes = probe.split(separator);
            map2 = new HashMap();
            for (i = 0; i < probes.length; ++i) {
                nameCriterion = new StringBuilder("probe").append(i);
                map2.put(nameCriterion.toString(), probes[i]);
            }
            groupsCriteria.put("probe", map2);
        }
        if (value != null) {
            String[] values = value.split(separator);
            map2 = new HashMap();
            for (i = 0; i < values.length; ++i) {
                nameCriterion = new StringBuilder("value").append(i);
                map2.put(nameCriterion.toString(), values[i]);
            }
            groupsCriteria.put("value", map2);
        }
        if (startTimestamp != null) {
            map = new HashMap<String, Date>();
            map.put("startTimestamp", startTimestamp);
            groupsCriteria.put("startTimestamp", map);
        }
        if (endTimestamp != null) {
            map = new HashMap();
            map.put("endTimestamp", endTimestamp);
            groupsCriteria.put("endTimestamp", map);
        }
        StringBuilder stringQuery = new StringBuilder();
        stringQuery.append("SELECT e FROM ").append(EVENT_CLASS_NAME).append(" e");
        if (groupsCriteria.size() != 0) {
            stringQuery.append(" WHERE");
            boolean isFirstGroup = true;
            for (String groupName : groupsCriteria.keySet()) {
                if (isFirstGroup) {
                    isFirstGroup = false;
                } else {
                    stringQuery.append(" AND");
                }
                stringQuery.append(" (");
                boolean isFirstCriterion = true;
                for (String criterionName : ((Map)groupsCriteria.get(groupName)).keySet()) {
                    if (isFirstCriterion) {
                        isFirstCriterion = false;
                    } else {
                        stringQuery.append(" OR");
                    }
                    if (groupName.equals("startTimestamp")) {
                        stringQuery.append(" e.timestamp >=");
                    } else if (groupName.equals("endTimestamp")) {
                        stringQuery.append(" e.timestamp <=");
                    } else {
                        stringQuery.append(" UPPER(").append(" e.").append(groupName).append(") LIKE");
                    }
                    stringQuery.append(" :").append(criterionName);
                }
                stringQuery.append(" )");
            }
        }
        if (orderBy != null) {
            stringQuery.append(" ORDER BY e.").append(orderBy).append(" ASC");
        }
        Query dbQuery = this.entityManager.createQuery(stringQuery.toString());
        if (indexFirstResult > 0) {
            dbQuery.setFirstResult(indexFirstResult);
        }
        if (limit > 0) {
            dbQuery.setMaxResults(limit);
        }
        for (Map map3 : groupsCriteria.values()) {
            for (Map.Entry entry : map3.entrySet()) {
                if (entry.getValue() instanceof String) {
                    String val = (String)entry.getValue();
                    dbQuery.setParameter((String)entry.getKey(), (Object)("%" + val.toUpperCase() + "%"));
                    continue;
                }
                dbQuery.setParameter((String)entry.getKey(), entry.getValue());
            }
        }
        List queryResult = dbQuery.getResultList();
        JasmineEventEB[] resultTable = null;
        if (queryResult.size() != 0) {
            resultTable = new JasmineEventEB[queryResult.size()];
            int i2 = 0;
            for (JasmineEventEBImpl eventEB : queryResult) {
                resultTable[i2++] = new JasmineEventEB(eventEB.getDomain(), eventEB.getServer(), eventEB.getSource(), eventEB.getProbe(), (Serializable)((Object)eventEB.getValue()), eventEB.getTimestamp(), eventEB.getSname());
            }
        }
        return resultTable;
    }
}

