/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineEventNotificationActionEBImpl.java 7134 2010-11-17 17:28:05Z joaninh $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.monitoring.eventswitch.beans.impl;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.ow2.jasmine.event.beans.JasmineEventNotification;

@Entity
@Table(name = "JM_EVENT_NOTIFICATIONS_ACTIONS")
public class JasmineEventNotificationActionEBImpl implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = -5337125420746859697L;

    /**
     * Primary key.
     */
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;

    /**
     * Comment for the action.
     */
    @Column(name="c_comment")
    private String comment = null;

    /**
     * Name of the executed action.
     */
    private String action = null;

    /**
     * Date of the time action.
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "dateStamp")
    private Date date = null;

    /**
     * The user who executed the action.
     */
    @Column(name = "username")
    private String user = null;

    /**
     * notification parent.
     */
    @ManyToOne(cascade = CascadeType.ALL)
    @JoinColumn(name = "NOTIFICATION_ID", nullable = false)
    private JasmineEventNotificationEBImpl notification = null;

    /**
     * Default Constructor
     */
    public JasmineEventNotificationActionEBImpl() {
        super();
    }

    /**
     * Constructor using fields ...
     *
     * @param comment Comment of the user that executed the action.
     * @param action Action executed
     * @param date Date when the action was executed
     */
    public JasmineEventNotificationActionEBImpl(final String comment, final String action, final Date date, final String user) {
        super();
        this.comment = comment;
        this.action = action;
        this.date = date;
        this.user = user;
    }

    /**
     * @return Primary key
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id Primary key
     */
    public void setId(final Long id) {
        this.id = id;
    }

    /**
     * @return the comment
     */
    public String getComment() {
        return comment;
    }

    /**
     * @param comment the comment to set
     */
    public void setComment(final String comment) {
        this.comment = comment;
    }

    /**
     * @return the action
     */
    public String getAction() {
        return action;
    }

    /**
     * @param action the action to set
     */
    public void setAction(final String action) {
        this.action = action;
    }

    /**
     * @return the date
     */
    @Column(name = "dateStamp")
    public Date getDate() {
        return date;
    }

    /**
     * @param date the date to set
     */
    @Column(name = "dateStamp")
    public void setDate(final Date date) {
        this.date = date;
    }

    /**
     * @return the notification
     */
    public JasmineEventNotificationEBImpl getNotification() {
        return notification;
    }

    /**
     * @param notification the notification to set
     */
    public void setNotification(final JasmineEventNotificationEBImpl notification) {
        this.notification = notification;
    }

    /**
     * @return the user
     */
    @Column(name = "username")
    public String getUser() {
        return user;
    }

    /**
     * @param user the user to set
     */
    @Column(name = "username")
    public void setUser(final String user) {
        this.user = user;
    }

    /**
     * Two {@link JasmineEventNotificationActionEBImpl} are equals only if the
     * action, the comment, the date, the user and the
     * {@link JasmineEventNotification#getId()} are equals.
     *
     * @return <code>true</code> if the two objects are equals,
     *         <code>false</code> otherwise.
     */
    @Override
    public boolean equals(final Object obj) {

        boolean result = true;

        if (obj instanceof JasmineEventNotificationActionEBImpl) {
            JasmineEventNotificationActionEBImpl action = (JasmineEventNotificationActionEBImpl) obj;
            result &= this.action.equals(action.getAction());
            result &= this.comment.equals(action.getComment());
            result &= this.date.equals(action.getDate());
            result &= this.user.equals(action.getUser());
            result &= this.notification.getId().equals(action.getNotification().getId());
        } else {
            result = false;
        }

        return result;
    }

    /**
     * @return the hashcode of this object, based on the action hashcode, the
     *         comment hashcode, the date hashcode, the user hascode and the
     *         notificaiton hashcode.
     */
    @Override
    public int hashCode() {

        return this.action.hashCode() + this.comment.hashCode() + this.date.hashCode() + this.user.hashCode()
            + this.notification.hashCode();
    }

}
