/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.beans.impl;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.ow2.jasmine.event.messages.JasmineEventPurgeTask;
import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventPurgeTaskSLBRemote;
import org.ow2.jasmine.monitoring.eventswitch.beans.impl.JasmineEventEBImpl;
import org.ow2.jasmine.monitoring.eventswitch.beans.impl.JasmineEventPurgeTaskEB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless(mappedName="db-ejb/purgetask")
@Remote(value={JasmineEventPurgeTaskSLBRemote.class})
public class JasmineEventPurgeTaskSLBImpl
implements JasmineEventPurgeTaskSLBRemote {
    static final String EVENT_CLASS_NAME = JasmineEventEBImpl.class.getName();
    private Logger logger = Logger.getLogger(this.getClass().getName());
    @Resource
    private SessionContext sessionContext;
    private TimerService timerService = null;
    @PersistenceContext(unitName="persistence-unit/purgetask")
    private EntityManager entityManager = null;
    @Resource(mappedName="JTCF")
    private ConnectionFactory factory;
    @Resource(mappedName="jasminePurgeTask")
    private Topic topic;

    @PostConstruct
    private void getTimerService() {
        this.timerService = this.sessionContext.getTimerService();
    }

    public void activatePeriodicPurgeTasks() {
        this.cancelAllTimers();
        List beans = this.entityManager.createNamedQuery("ALL_PURGE_TASKS").getResultList();
        for (JasmineEventPurgeTaskEB bean : beans) {
            if (bean.getExecutionInterval() <= 0L) continue;
            this.createTask(bean);
        }
    }

    @Timeout
    public void handleTimeout(Timer timer) {
        this.deleteEventsFromDB(timer.getInfo());
    }

    private void cancelAllTimers() {
        Collection timers = this.timerService.getTimers();
        for (Timer timer : timers) {
            timer.cancel();
        }
        timers.clear();
    }

    private JasmineEventPurgeTask beanToEvent(JasmineEventPurgeTaskEB bean) {
        JasmineEventPurgeTask event = new JasmineEventPurgeTask();
        event.setId(bean.getId());
        event.setMaxEntryAge(bean.getMaxEntryAge());
        event.setMaxEntryNumber(bean.getMaxEntryNumber());
        event.setExecuteOnAllServers(bean.isExecuteOnAllServers());
        event.setDomainName(bean.getDomainName());
        event.setServerName(bean.getServerName());
        event.setExecutionStartDate(bean.getExecutionStartDate());
        event.setExecutionInterval(bean.getExecutionInterval());
        event.setStarted(bean.isStarted());
        event.setRemovedEvents(bean.getRemovedEvents());
        event.setLastExecutionDate(bean.getLastExecutionDate());
        return event;
    }

    private void createTask(JasmineEventPurgeTaskEB bean) {
        if (bean.getExecutionInterval() == 0L) {
            this.timerService.createTimer(bean.getExecutionStartDate(), (Serializable)Long.valueOf(bean.getId()));
            this.logger.info("[DataManagement] Purge Task configured, execution : " + bean.getExecutionStartDate());
        } else {
            this.timerService.createTimer(bean.getExecutionStartDate(), bean.getExecutionInterval(), (Serializable)Long.valueOf(bean.getId()));
            bean.setStarted(true);
            this.logger.info("[DataManagement] Purge Task configured, first execution : " + bean.getExecutionStartDate());
        }
    }

    private void removeTask(JasmineEventPurgeTaskEB bean) {
        Collection timers = this.timerService.getTimers();
        for (Timer timer : timers) {
            if (Long.parseLong(timer.getInfo().toString()) != bean.getId()) continue;
            timer.cancel();
        }
        bean.setStarted(false);
        this.logger.info("[DataManagement] Purge Task removed : " + bean.getId());
    }

    public JasmineEventPurgeTask configurePurgeTask(JasmineEventPurgeTask event) {
        JasmineEventPurgeTaskEB bean = new JasmineEventPurgeTaskEB();
        this.logger.fine("------------------------------------\n\n\n");
        this.logger.fine(" Event Received with attributes:");
        this.logger.fine(" - MaxEntryAge :" + event.getMaxEntryAge());
        this.logger.fine(" - MaxEntryNumber :" + event.getMaxEntryNumber());
        this.logger.fine(" - ExecuteOnAllServers :" + event.isExecuteOnAllServers());
        this.logger.fine(" - DomainName :" + event.getDomainName());
        this.logger.fine(" - ServerName :" + event.getServerName());
        this.logger.fine(" - ExecutionStartDate :" + event.getExecutionStartDate());
        this.logger.fine(" - ExecutionInterval :" + event.getExecutionInterval());
        this.logger.fine("\n\n\n------------------------------------");
        bean.setMaxEntryAge(event.getMaxEntryAge());
        bean.setMaxEntryNumber(event.getMaxEntryNumber());
        bean.setExecuteOnAllServers(event.isExecuteOnAllServers());
        if (!event.isExecuteOnAllServers()) {
            bean.setDomainName(event.getDomainName());
            bean.setServerName(event.getServerName());
        }
        if (event.getExecutionStartDate() == null) {
            event.setExecutionStartDate(new Date(System.currentTimeMillis()));
        }
        bean.setExecutionStartDate(event.getExecutionStartDate());
        bean.setExecutionInterval(event.getExecutionInterval());
        this.entityManager.persist((Object)bean);
        this.createTask(bean);
        event.setId(bean.getId());
        event.setStarted(bean.isStarted());
        return event;
    }

    public List<JasmineEventPurgeTask> listPurgeTasks() {
        List beans = this.entityManager.createNamedQuery("ALL_PURGE_TASKS").getResultList();
        LinkedList<JasmineEventPurgeTask> result = new LinkedList<JasmineEventPurgeTask>();
        for (JasmineEventPurgeTaskEB bean : beans) {
            result.add(this.beanToEvent(bean));
        }
        return result;
    }

    public long removePurgeTask(long purgeTaskId) {
        JasmineEventPurgeTaskEB bean = (JasmineEventPurgeTaskEB)this.entityManager.find(JasmineEventPurgeTaskEB.class, (Object)purgeTaskId);
        if (bean == null) {
            return -1L;
        }
        this.removeTask(bean);
        this.entityManager.remove((Object)bean);
        return purgeTaskId;
    }

    public long startPurgeTask(long purgeTaskId) {
        JasmineEventPurgeTaskEB bean = (JasmineEventPurgeTaskEB)this.entityManager.find(JasmineEventPurgeTaskEB.class, (Object)purgeTaskId);
        if (bean == null) {
            return -1L;
        }
        this.createTask(bean);
        this.sendPurgeTaskOnTopic(bean);
        return purgeTaskId;
    }

    public long pausePurgeTask(long purgeTaskId) {
        JasmineEventPurgeTaskEB bean = (JasmineEventPurgeTaskEB)this.entityManager.find(JasmineEventPurgeTaskEB.class, (Object)purgeTaskId);
        if (bean == null) {
            return -1L;
        }
        this.removeTask(bean);
        this.sendPurgeTaskOnTopic(bean);
        return purgeTaskId;
    }

    private void deleteEventsFromDB(Serializable beanId) {
        JasmineEventPurgeTaskEB bean = (JasmineEventPurgeTaskEB)this.entityManager.find(JasmineEventPurgeTaskEB.class, (Object)beanId);
        if (bean == null) {
            this.logger.info("[DataManagement] No cleanup parameters found in database");
            return;
        }
        Long maxNumber = new Long(bean.getMaxEntryNumber());
        StringBuilder stringQueryMax = new StringBuilder();
        stringQueryMax.append("Select max(e.id) from ").append(EVENT_CLASS_NAME).append(" e");
        Query dbQueryMax = this.entityManager.createQuery(stringQueryMax.toString());
        Long maxPrimaryKeyId = (Long)dbQueryMax.getSingleResult();
        if (maxPrimaryKeyId == null) {
            this.logger.info("[DataManagement] No events to delete in database");
            return;
        }
        Long minPrimaryKeyId = maxPrimaryKeyId - maxNumber;
        Calendar cal = Calendar.getInstance();
        Date endDate = cal.getTime();
        long timeDiff = bean.getMaxEntryAge();
        Date startDate = new Date(endDate.getTime() - timeDiff);
        StringBuilder stringQuery = new StringBuilder();
        if (maxNumber != -1L) {
            stringQuery.append("DELETE FROM ").append(EVENT_CLASS_NAME).append(" e").append(" WHERE (e.id NOT BETWEEN :min AND :max)");
        } else {
            stringQuery.append("DELETE FROM ").append(EVENT_CLASS_NAME).append(" e").append(" WHERE (e.timestamp NOT BETWEEN :start AND :end)");
        }
        if (!bean.isExecuteOnAllServers()) {
            stringQuery.append(" AND (e.domain=:domain AND e.server=:server)");
        }
        Query dbQuery = this.entityManager.createQuery(stringQuery.toString());
        this.logger.fine(" - Query to db : " + dbQuery.toString());
        this.logger.fine(" - Query to min : " + minPrimaryKeyId);
        this.logger.fine(" - Query to max : " + maxPrimaryKeyId);
        this.logger.fine(" - Query to start : " + startDate);
        this.logger.fine(" - Query to end : " + endDate);
        if (bean.isExecuteOnAllServers()) {
            if (maxNumber != -1L) {
                dbQuery.setParameter("min", (Object)minPrimaryKeyId).setParameter("max", (Object)maxPrimaryKeyId);
            } else {
                dbQuery.setParameter("start", (Object)startDate).setParameter("end", (Object)endDate);
            }
        } else if (maxNumber != -1L) {
            dbQuery.setParameter("min", (Object)minPrimaryKeyId).setParameter("max", (Object)maxPrimaryKeyId).setParameter("domain", (Object)bean.getDomainName()).setParameter("server", (Object)bean.getServerName());
        } else {
            dbQuery.setParameter("start", (Object)startDate).setParameter("end", (Object)endDate).setParameter("domain", (Object)bean.getDomainName()).setParameter("server", (Object)bean.getServerName());
        }
        int result = dbQuery.executeUpdate();
        bean.setRemovedEvents(result);
        bean.setLastExecutionDate(Calendar.getInstance().getTime());
        this.sendPurgeTaskOnTopic(bean);
        this.logger.info("[DataManagement] Purge Task cleaned up " + result + " events");
    }

    private void sendPurgeTaskOnTopic(JasmineEventPurgeTaskEB bean) {
        try {
            Connection connection = this.factory.createConnection();
            Session session = connection.createSession(false, 1);
            ObjectMessage message = session.createObjectMessage((Serializable)this.beanToEvent(bean));
            MessageProducer producer = session.createProducer((Destination)this.topic);
            producer.send((Message)message);
            session.close();
            connection.close();
        }
        catch (Exception e) {
            this.logger.fine(e.getMessage());
        }
    }
}

