/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id$
 */
package org.ow2.jasmine.monitoring.eventswitch.beans.impl;

import java.io.Serializable;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * @author Jean-Pierre Poutcheu Generic details about a Jasmine event
 *         notification
 */

@Entity
@Table(name = "JM_EVENT_NOTIFICATIONS_DETAILS")
public class JasmineEventDetailEB implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * the primary key.
     */
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private int id;

    /**
     * key.
     */
    @Column(name="c_key")
    private String key;

    /**
     * value.
     */
    private String value;

    /**
     * notification parent.
     */
    @ManyToOne(cascade = CascadeType.ALL)
    @JoinColumn(name = "NOTIFICATION_ID", nullable = false)
    private JasmineEventNotificationEBImpl notification;

    /**
     * default constructor
     */
    public JasmineEventDetailEB() {
        super();
    }

    /**
     * @param key
     * @param value
     */
    public JasmineEventDetailEB(final String key, final String value) {
        super();
        this.key = key;
        this.value = value;
    }

    /**
     * @return the primary key
     */
    public int getId() {
        return id;
    }

    /**
     * @param id set the primary key
     */
    public void setId(final int id) {
        this.id = id;
    }

    /**
     * @return the key
     */
    public String getKey() {
        return key;
    }

    /**
     * @param key the key to set
     */
    public void setKey(final String key) {
        this.key = key;
    }

    /**
     * @return the value
     */
    public String getValue() {
        return value;
    }

    /**
     * @param value the value to set
     */
    public void setValue(final String value) {
        this.value = value;
    }

    /**
     * @return the notification
     */
    public JasmineEventNotificationEBImpl getNotification() {
        return notification;
    }

    /**
     * @param notification the notification to set
     */
    public void setNotification(final JasmineEventNotificationEBImpl notification) {
        this.notification = notification;
    }

    /**
     * @return the string detail description
     */
    @Override
    public String toString() {
        return "Key : " + this.getKey() + ", value : " + this.getValue();
    }

    /**
     * Two {@link JasmineEventDetailEB} are equals only if the key, the value
     * and the referenced {@link JasmineEventNotificationEBImpl} are the same.
     *
     * @return <code>true</code> if the two events details are the same,
     *         <code>false</code> otherwise.
     */
    @Override
    public boolean equals(final Object obj) {
        boolean result = true;
        if (obj instanceof JasmineEventDetailEB) {
            result &= this.key.equals(((JasmineEventDetailEB) obj).getKey());
            result &= this.value.equals(((JasmineEventDetailEB) obj).getValue());
            result &= this.notification.getId().equals(((JasmineEventDetailEB) obj).getNotification().getId());
        } else {
            result = false;
        }
        return result;
    }

    /**
     * @return hashcode of this object, based on the key hashcode, the value
     *         hashcode and the notification hashcode.
     */
    @Override
    public int hashCode() {

        return this.key.hashCode() + this.value.hashCode() + this.notification.hashCode();
    }

}
