/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.beans.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.ow2.jasmine.event.beans.JasmineEventNotificationDetail;
import org.ow2.jasmine.event.beans.JasmineEventNotificationExecutedAction;
import org.ow2.jasmine.monitoring.eventswitch.beans.impl.JasmineEventDetailEB;
import org.ow2.jasmine.monitoring.eventswitch.beans.impl.JasmineEventNotificationActionEBImpl;

@Entity
@Table(name="JM_EVENT_NOTIFICATIONS")
public class JasmineEventNotificationEBImpl
implements Serializable {
    private static final long serialVersionUID = 3603043818875621406L;
    @Id
    private String id;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="dateStamp")
    private Date date;
    @Column(name="levelDegree")
    private String level;
    private String message;
    private Boolean status;
    private String rule;
    @OneToMany(mappedBy="notification", cascade={CascadeType.ALL})
    @OrderBy(value="key ASC")
    private List<JasmineEventDetailEB> details = new ArrayList<JasmineEventDetailEB>();
    @OneToMany(mappedBy="notification", cascade={CascadeType.ALL})
    private List<JasmineEventNotificationActionEBImpl> actions = new ArrayList<JasmineEventNotificationActionEBImpl>();

    public String getId() {
        return this.id;
    }

    public void setId(String i) {
        this.id = i;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date d) {
        this.date = d;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String l) {
        this.level = l;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String m) {
        this.message = m;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public void setStatus(Boolean s) {
        this.status = s;
    }

    public String getRule() {
        return this.rule;
    }

    public void setRule(String r) {
        this.rule = r;
    }

    public List<JasmineEventDetailEB> getDetails() {
        return this.details;
    }

    public void setDetails(List<JasmineEventDetailEB> details) {
        this.details = details;
    }

    public boolean addDetail(JasmineEventDetailEB p_Detail) {
        boolean result;
        int index = -1;
        for (JasmineEventDetailEB detail : this.getDetails()) {
            if (null == detail.getKey() || !detail.getKey().equals(p_Detail.getKey())) continue;
            index = this.getDetails().indexOf(detail);
            break;
        }
        if (-1 == index) {
            if (null == p_Detail.getNotification()) {
                p_Detail.setNotification(this);
            }
            this.getDetails().add(p_Detail);
            result = false;
        } else {
            this.getDetails().get(index).setValue(p_Detail.getValue());
            result = true;
        }
        return result;
    }

    public List<JasmineEventNotificationDetail> getNotificationDetails() {
        ArrayList<JasmineEventNotificationDetail> detailsList = new ArrayList<JasmineEventNotificationDetail>();
        for (JasmineEventDetailEB detail : this.details) {
            detailsList.add(new JasmineEventNotificationDetail(detail.getKey(), detail.getValue()));
        }
        return detailsList;
    }

    public List<JasmineEventNotificationExecutedAction> getActions() {
        ArrayList<JasmineEventNotificationExecutedAction> actions = new ArrayList<JasmineEventNotificationExecutedAction>();
        for (JasmineEventNotificationActionEBImpl jasmineEventNotificationActionEBImpl : this.actions) {
            actions.add(new JasmineEventNotificationExecutedAction(jasmineEventNotificationActionEBImpl.getComment(), jasmineEventNotificationActionEBImpl.getAction(), jasmineEventNotificationActionEBImpl.getDate(), jasmineEventNotificationActionEBImpl.getUser()));
        }
        return actions;
    }

    public void setActions(List<JasmineEventNotificationActionEBImpl> actions) {
        this.actions = actions;
    }

    public void addAction(JasmineEventNotificationActionEBImpl action) {
        if (null == action.getNotification()) {
            action.setNotification(this);
        }
        if (!this.actions.contains(action)) {
            this.actions.add(action);
        }
    }
}

