/**
 * JASMINe
 * Copyright (C) 2009-2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eventswitch.beans.impl;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * Entity bean for a JASMINe Purge Task Event.
 */
@Entity
@Table(name = "JM_EVENT_PURGE_TASK_SETTINGS")
@NamedQuery(name = "ALL_PURGE_TASKS", query = "select o FROM JasmineEventPurgeTaskEB o")
public class JasmineEventPurgeTaskEB implements Serializable {

    private static final long serialVersionUID = 6640605662388109776L;

    /**
     * the primary key.
     */
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private long id;

    private long maxEntryAge;

    private int maxEntryNumber;

    /**
     ** Notification date.
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "dateStamp")
    private Date executionStartDate;

    private long executionInterval;

    private boolean executeOnAllServers;

    private String domainName;

    private String serverName;

    private boolean started;

    private int removedEvents;

    @Temporal(TemporalType.TIMESTAMP)
    private Date lastExecutionDate;

    /**
     * @return the maxEntryAge
     */
    public long getMaxEntryAge() {
        return maxEntryAge;
    }

    /**
     * @param maxEntryAge the maxEntryAge to set
     */
    public void setMaxEntryAge(final long maxEntryAge) {
        this.maxEntryAge = maxEntryAge;
    }

    /**
     * @return the maxEntryNumber
     */
    public int getMaxEntryNumber() {
        return maxEntryNumber;
    }

    /**
     * @param maxEntryNumber the maxEntryNumber to set
     */
    public void setMaxEntryNumber(final int maxEntryNumber) {
        this.maxEntryNumber = maxEntryNumber;
    }

    /**
     * @return the executionStartDate
     */
    public Date getExecutionStartDate() {
        return executionStartDate;
    }

    /**
     * @param executionStartDate the executionStartDate to set
     */
    public void setExecutionStartDate(final Date executionStartDate) {
        this.executionStartDate = executionStartDate;
    }

    /**
     * @return the executionInterval
     */
    public long getExecutionInterval() {
        return executionInterval;
    }

    /**
     * @param executionInterval the executionInterval to set
     */
    public void setExecutionInterval(final long executionInterval) {
        this.executionInterval = executionInterval;
    }

    /**
     * @return the executeOnAllServers
     */
    public boolean isExecuteOnAllServers() {
        return executeOnAllServers;
    }

    /**
     * @param executeOnAllServers the executeOnAllServers to set
     */
    public void setExecuteOnAllServers(final boolean executeOnAllServers) {
        this.executeOnAllServers = executeOnAllServers;
    }

    /**
     * @return the domainName
     */
    public String getDomainName() {
        return domainName;
    }

    /**
     * @param domainName the domainName to set
     */
    public void setDomainName(final String domainName) {
        this.domainName = domainName;
    }

    /**
     * @return the serverName
     */
    public String getServerName() {
        return serverName;
    }

    /**
     * @param serverName the serverName to set
     */
    public void setServerName(final String serverName) {
        this.serverName = serverName;
    }

    /**
     * @return the serialVersionUID
     */
    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    /**
     * @return the id
     */
    public long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(final long id) {
        this.id = id;
    }

    /**
     * @return the started state
     */
    public boolean isStarted() {
        return started;
    }

    /**
     * @param started the started state to set
     */
    public void setStarted(final boolean started) {
        this.started = started;
    }

    /**
     * @return the removed events number
     */
    public int getRemovedEvents() {
        return removedEvents;
    }

    /**
     * @param removedEvents the removed events number to set
     */
    public void setRemovedEvents(final int removedEvents) {
        this.removedEvents = removedEvents;
    }

    /**
     * @param The last purge task execution date
     */
    public Date getLastExecutionDate() {
        return lastExecutionDate;
    }

    /**
     * @param lastExecutionDate The last purge task execution date to set
     */
    public void setLastExecutionDate(final Date lastExecutionDate) {
        this.lastExecutionDate = lastExecutionDate;
    }

}
