/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.beans.impl;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.ow2.easybeans.osgi.annotation.OSGiResource;
import org.ow2.jasmine.monitoring.eventswitch.beans.DroolsWorkingMemorySFBRemote;
import org.ow2.jasmine.rules.api.IDroolsWorkingMemoryPool;
import org.ow2.util.log.LogFactory;

@Stateless(mappedName="ejb3-drools-insert-fact")
@Remote(value={DroolsWorkingMemorySFBRemote.class})
public class DroolsWorkingMemorySFBImpl
implements DroolsWorkingMemorySFBRemote {
    @OSGiResource
    private BundleContext bundleContext = null;
    private ServiceListener workingMemoryPoolListener;
    private IDroolsWorkingMemoryPool droolsWorkingMemoryPool;
    private ServiceReference workingMemoryPoolReference;

    @PostConstruct
    public void start() {
        this.workingMemoryPoolListener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                ServiceReference ref = event.getServiceReference();
                switch (event.getType()) {
                    case 1: {
                        DroolsWorkingMemorySFBImpl.this.droolsWorkingMemoryPool = (IDroolsWorkingMemoryPool)DroolsWorkingMemorySFBImpl.this.bundleContext.getService(ref);
                        DroolsWorkingMemorySFBImpl.this.workingMemoryPoolReference = ref;
                        break;
                    }
                    case 4: {
                        DroolsWorkingMemorySFBImpl.this.droolsWorkingMemoryPool = null;
                        DroolsWorkingMemorySFBImpl.this.workingMemoryPoolReference = null;
                    }
                }
            }
        };
        try {
            this.bundleContext.addServiceListener(this.workingMemoryPoolListener, "(objectClass=IDroolsWorkingMemoryPool)");
        }
        catch (InvalidSyntaxException e) {
            LogFactory.getLog(this.getClass()).error((Object)"Cannot add a listener for the working memory pool", new Object[]{e});
        }
        this.workingMemoryPoolReference = this.bundleContext.getServiceReference(IDroolsWorkingMemoryPool.class.getName());
        if (this.workingMemoryPoolReference != null) {
            this.droolsWorkingMemoryPool = (IDroolsWorkingMemoryPool)this.bundleContext.getService(this.workingMemoryPoolReference);
        }
    }

    @PreDestroy
    public void stop() {
        if (this.workingMemoryPoolListener != null) {
            this.bundleContext.removeServiceListener(this.workingMemoryPoolListener);
        }
        if (this.workingMemoryPoolReference != null) {
            this.bundleContext.ungetService(this.workingMemoryPoolReference);
        }
    }

    public void insert(Object fact) {
        if (this.droolsWorkingMemoryPool != null) {
            this.droolsWorkingMemoryPool.insertAll(fact);
        }
    }
}

