/**
 * JASMINe
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eventswitch.extractor;

import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

/**
 * Parses command line arguments.
 *
 * @author http://www.devx.com/tips/Tip/13004
 */
class ArgumentParser {
    /**
     * Initializes the command line argument parser based on the command
     * line arguments. By default, we consider two cases:
     *      1. An option, which starts with a - or a /, followed by the name of
     *         the option, a space and the value. For example:
     *              -jasmine vm://eventSwitch
     *         In that case, getOption("jasmine").equals("vm://eventSwitch").
     *      2. A parameter, which only sets a certain property. For example:
     *              poll
     *         In that case, hasParameter("poll") == true.
     *
     * @param args  Arguments passed to main(String[]).
     */
    public ArgumentParser(final String[] args) {
        String current = null;
        for(String arg : args) {
            if(arg.startsWith("-") || arg.startsWith("/")) {
                current = arg.substring(1);
            } else if(current != null) {
                options.put(current, arg);
                current = null;
            } else {
                parameters.add(arg);
            }
        }
    }

    /**
     * Gets the value of an option.
     *
     * @param o  Option name to look for.
     *
     * @return  Value of that option, null if none found.
     */
    public String getOption(final String o) {
        return options.get(o.toLowerCase(Locale.ENGLISH));
    }

    /**
     * Checks if a parameter has been set.
     *
     * @param p  Parameter name to look for.
     *
     * @return  true if parameter p has been set, false otherwise.
     */
    public boolean hasParameter(final String p) {
        return parameters.contains(p.toLowerCase(Locale.ENGLISH));
    }

    /**
     * @return  All options.
     */
    public Hashtable<String, String> getOptions() {
        return options;
    }

    /**
     * Parameters.
     */
    private Vector<String> parameters = new Vector<String>();

    /**
     * Options.
     */
    private Hashtable<String, String> options = new Hashtable<String, String>();
}
