/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.extractor;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TreeSet;
import javax.naming.NamingException;
import org.ow2.jasmine.event.beans.JasmineEventEB;
import org.ow2.jasmine.monitoring.common.util.extractor.AbstractJasmineEventDataExtractor;

public class JasmineEventDataExtractor
extends AbstractJasmineEventDataExtractor {
    public static void main(String[] args) throws NamingException, ParseException, IOException {
        JasmineEventDataExtractor extractor = new JasmineEventDataExtractor();
        JasmineEventEB[] events = extractor.getEvents(args);
        extractor.printEvents(events);
    }

    public void printEvents(JasmineEventEB[] events) {
        if (events == null) {
            return;
        }
        TreeSet<String> attributes = new TreeSet<String>();
        for (JasmineEventEB event : events) {
            attributes.add(event.getProbe().substring(event.getProbe().lastIndexOf(58) + 1));
        }
        System.out.print("date;time;server;domain;mbean");
        for (String attribute : attributes) {
            System.out.print(";");
            System.out.print(attribute);
        }
        System.out.println();
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        for (JasmineEventEB event : events) {
            System.out.print(df.format(event.getTimestamp()));
            System.out.print(";");
            System.out.print(event.getTimestamp().getTime());
            System.out.print(";");
            System.out.print(event.getServer());
            System.out.print(";");
            System.out.print(event.getDomain());
            System.out.print(";");
            System.out.print(event.getProbe().substring(0, event.getProbe().lastIndexOf(58)));
            String attribute = event.getProbe().substring(event.getProbe().lastIndexOf(58) + 1);
            for (String cAttribute : attributes) {
                System.out.print(";");
                if (!cAttribute.equals(attribute)) continue;
                System.out.print(event.getValue());
            }
            System.out.println();
        }
    }
}

