/**
 * JASMINe
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eventswitch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;

import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

import org.mule.MuleManager;
import org.mule.MuleServer;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ReaderResource;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.objectweb.jonas.common.JProp;

/**
 * Wrapper class for Mule.
 */
public class MuleWrapper implements ResourceAdapter {
    /**
     * Launches the MuleServer's main method with the given arguments and
     * enters an infinite loop.
     *
     * @see org.mule.MuleServer#main(String[])
     *
     * @param args  Command-line arguments to pass to the MuleServer.
     */
    public static void main(final String[] args) {
        MuleServer.main(args);

        // Sleep for about 292 million 471 thousand 208 years,
        // then repeat infinitely many times.
        while(true) {
            try {
                Thread.sleep(Long.MAX_VALUE);
            } catch (InterruptedException e) {
                // Nothing
            }
        }
    }

    /**
     * Implements inherited abstract method. Configures Mule, which will
     * automatically launch it.
     *
     * @param ctx  Bootstrap context containing references to useful facilities
     *             that could be used by a resource adapter instance.
     *
     * @throws ResourceAdapterInternalException Bootstrap failure. The resource
     *                                          adapter instance is unusable
     *                                          and must be discarded.
     */
    public void start(final BootstrapContext ctx) throws ResourceAdapterInternalException {
        InputStream inputStream;
        try {
            inputStream = new FileInputStream(new File(JProp.getConfDir(), "eventswitch-config.xml"));
        } catch (FileNotFoundException e) {
            throw new ResourceAdapterInternalException("Cannot read the config file 'eventswitch-config.xml'", e);
        }
        if(inputStream == null) {
            throw new ResourceAdapterInternalException("Cannot read the config file 'eventswitch-config.xml'");
        }

        if (MuleManager.isInstanciated()) {
            throw new ResourceAdapterInternalException("A Mule instance is already present");
        }

        try {
            ConfigurationBuilder builder = new MuleXmlConfigurationBuilder();
            ReaderResource configReader = new ReaderResource("eventswitch", new InputStreamReader(inputStream));
            builder.configure(new ReaderResource[]{configReader}, null);
            //builder.configure("eventswitch-config.xml");
        } catch(Exception e) {
            MuleManager.getInstance().dispose();
            throw new ResourceAdapterInternalException("Failed configuring Mule", e);
        }
    }

    /**
     * Implements inherited abstract method. Disposes of Mule.
     */
    public void stop() {
        MuleManager.getInstance().dispose();
    }

    /**
     * Empty implementation of inherited abstract method.
     *
     * @see ResourceAdapter#endpointActivation(MessageEndpointFactory, ActivationSpec)
     */
    public void endpointActivation(final MessageEndpointFactory endpointFactory, final ActivationSpec spec) throws ResourceException {
        // TODO Auto-generated method stub
    }

    /**
     * Empty implementation of inherited abstract method.
     *
     * @see ResourceAdapter#endpointDeactivation(MessageEndpointFactory, ActivationSpec)
     */
    public void endpointDeactivation(final MessageEndpointFactory endpointFactory, final ActivationSpec spec) {
        // TODO Auto-generated method stub
    }

    /**
     * Empty implementation of inherited abstract method.
     *
     * @see ResourceAdapter#getXAResources(ActivationSpec[])
     */
    public XAResource[] getXAResources(final ActivationSpec[] specs) throws ResourceException {
        // TODO Auto-generated method stub
        return null;
    }
}
