/**
 * JASMINe
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: MuleWrapper.java 4798 2009-08-07 12:30:47Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eventswitch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

import org.mule.MuleManager;
import org.mule.MuleServer;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ReaderResource;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.umo.manager.UMOManager;
import org.objectweb.jonas.common.JProp;
import org.ow2.jasmine.monitoring.eventswitch.manager.EventSwitchManager;

/**
 * Wrapper class for Mule.
 */
public class MuleWrapper implements ResourceAdapter {

    /**
     * EventSwitchManager. The instance is unique.
     */
    private EventSwitchManager manager = null;

    /**
     * JMX Server.
     */
    private MBeanServer mbeanServer = null;

    /**
     * OBjectname of the Manager.
     */
    private ObjectName objName = null;

    /**
     * Launches the MuleServer's main method with the given arguments and
     * enters an infinite loop.
     *
     * @see org.mule.MuleServer#main(String[])
     *
     * @param args  Command-line arguments to pass to the MuleServer.
     */
    public static void main(final String[] args) {
        MuleServer.main(args);

        // Sleep for about 292 million 471 thousand 208 years,
        // then repeat infinitely many times.
        while(true) {
            try {
                Thread.sleep(Long.MAX_VALUE);
            } catch (InterruptedException e) {
                // Nothing
            }
        }
    }

    /**
     * Implements inherited abstract method. Configures Mule, which will
     * automatically launch it.
     *
     * @param ctx  Bootstrap context containing references to useful facilities
     *             that could be used by a resource adapter instance.
     *
     * @throws ResourceAdapterInternalException Bootstrap failure. The resource
     *                                          adapter instance is unusable
     *                                          and must be discarded.
     */
    public void start(final BootstrapContext ctx) throws ResourceAdapterInternalException {
        InputStream inputStream;
        this.manager = EventSwitchManager.getInstance();
        try {
            inputStream = new FileInputStream(new File(JProp.getConfDir(), "eventswitch-config.xml"));
        } catch (FileNotFoundException e) {
            throw new ResourceAdapterInternalException("Cannot read the config file 'eventswitch-config.xml'", e);
        }
        if(inputStream == null) {
            throw new ResourceAdapterInternalException("Cannot read the config file 'eventswitch-config.xml'");
        }

        if (MuleManager.isInstanciated()) {
            throw new ResourceAdapterInternalException("A Mule instance is already present");
        }

        try {
            ConfigurationBuilder builder = new MuleXmlConfigurationBuilder();
            ReaderResource configReader = new ReaderResource("eventswitch", new InputStreamReader(inputStream));
            UMOManager umo = builder.configure(new ReaderResource[]{configReader}, null);

            this.manager.setMuleManager(umo);

            try {

                Class classServiceManager = Class.forName("org.objectweb.jonas.service.ServiceManager");
                Method getServiceManager = classServiceManager.getDeclaredMethod("getInstance");
                Object serviceManager = getServiceManager.invoke(classServiceManager);

                Method getService = classServiceManager.getDeclaredMethod("getJmxService");
                Object serviceJMX = getService.invoke(serviceManager);

                Class classJmxService = Class.forName("org.objectweb.jonas.jmx.JmxService");
                Method getJMXServer = classJmxService.getDeclaredMethod("getJmxServer");
                this.mbeanServer = (MBeanServer)getJMXServer.invoke(serviceJMX);

                Method getDomainName = classJmxService.getDeclaredMethod("getDomainName");
                String domainName = (String)getDomainName.invoke(serviceJMX);

                Method getJonasServerName = classJmxService.getDeclaredMethod("getJonasServerName");
                String serverName = (String)getJonasServerName.invoke(serviceJMX);

                this.objName = new ObjectName(domainName + ":type=EventSwitch,name=manager,J2EEServer=" +serverName );

                this.mbeanServer.registerMBean(this.manager, this.objName);

            } catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Failed registering EventSwitchManager MBean");
                throw new ResourceAdapterInternalException("Failed registering EventSwitchManager MBean", e);
            }

        } catch(Exception e) {
            MuleManager.getInstance().dispose();
            throw new ResourceAdapterInternalException("Failed configuring Mule", e);
        }
    }

    /**
     * Implements inherited abstract method. Disposes of Mule.
     */
    public void stop() {
        try {
            this.mbeanServer.unregisterMBean(this.objName);
        } catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Failed unregistering EventSwitchManager MBean");
        }
        this.manager.getMuleManager().dispose();
        EventSwitchManager.deleteInstance();
    }

    /**
     * Empty implementation of inherited abstract method.
     *
     * @see ResourceAdapter#endpointActivation(MessageEndpointFactory, ActivationSpec)
     */
    public void endpointActivation(final MessageEndpointFactory endpointFactory, final ActivationSpec spec) throws ResourceException {
        // TODO Auto-generated method stub
    }

    /**
     * Empty implementation of inherited abstract method.
     *
     * @see ResourceAdapter#endpointDeactivation(MessageEndpointFactory, ActivationSpec)
     */
    public void endpointDeactivation(final MessageEndpointFactory endpointFactory, final ActivationSpec spec) {
        // TODO Auto-generated method stub
    }

    /**
     * Empty implementation of inherited abstract method.
     *
     * @see ResourceAdapter#getXAResources(ActivationSpec[])
     */
    public XAResource[] getXAResources(final ActivationSpec[] specs) throws ResourceException {
        // TODO Auto-generated method stub
        return null;
    }
}
