/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.mule.MuleManager;
import org.mule.MuleServer;
import org.mule.config.ReaderResource;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.umo.manager.UMOManager;
import org.objectweb.jonas.common.JProp;
import org.ow2.jasmine.monitoring.eventswitch.manager.EventSwitchManager;

public class MuleWrapper
implements ResourceAdapter {
    private EventSwitchManager manager = null;
    private MBeanServer mbeanServer = null;
    private ObjectName objName = null;

    public static void main(String[] args) {
        MuleServer.main((String[])args);
        while (true) {
            try {
                while (true) {
                    Thread.sleep(Long.MAX_VALUE);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        FileInputStream inputStream;
        this.manager = EventSwitchManager.getInstance();
        try {
            inputStream = new FileInputStream(new File(JProp.getConfDir(), "eventswitch-config.xml"));
        }
        catch (FileNotFoundException e) {
            throw new ResourceAdapterInternalException("Cannot read the config file 'eventswitch-config.xml'", (Throwable)e);
        }
        if (inputStream == null) {
            throw new ResourceAdapterInternalException("Cannot read the config file 'eventswitch-config.xml'");
        }
        if (MuleManager.isInstanciated()) {
            throw new ResourceAdapterInternalException("A Mule instance is already present");
        }
        try {
            MuleXmlConfigurationBuilder builder = new MuleXmlConfigurationBuilder();
            ReaderResource configReader = new ReaderResource("eventswitch", (Reader)new InputStreamReader(inputStream));
            UMOManager umo = builder.configure(new ReaderResource[]{configReader}, null);
            this.manager.setMuleManager(umo);
            try {
                Class<?> classServiceManager = Class.forName("org.objectweb.jonas.service.ServiceManager");
                Method getServiceManager = classServiceManager.getDeclaredMethod("getInstance", new Class[0]);
                Object serviceManager = getServiceManager.invoke(classServiceManager, new Object[0]);
                Method getService = classServiceManager.getDeclaredMethod("getJmxService", new Class[0]);
                Object serviceJMX = getService.invoke(serviceManager, new Object[0]);
                Class<?> classJmxService = Class.forName("org.objectweb.jonas.jmx.JmxService");
                Method getJMXServer = classJmxService.getDeclaredMethod("getJmxServer", new Class[0]);
                this.mbeanServer = (MBeanServer)getJMXServer.invoke(serviceJMX, new Object[0]);
                Method getDomainName = classJmxService.getDeclaredMethod("getDomainName", new Class[0]);
                String domainName = (String)getDomainName.invoke(serviceJMX, new Object[0]);
                Method getJonasServerName = classJmxService.getDeclaredMethod("getJonasServerName", new Class[0]);
                String serverName = (String)getJonasServerName.invoke(serviceJMX, new Object[0]);
                this.objName = new ObjectName(domainName + ":type=EventSwitch,name=manager,J2EEServer=" + serverName);
                this.mbeanServer.registerMBean(this.manager, this.objName);
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Failed registering EventSwitchManager MBean");
                throw new ResourceAdapterInternalException("Failed registering EventSwitchManager MBean", (Throwable)e);
            }
        }
        catch (Exception e) {
            MuleManager.getInstance().dispose();
            throw new ResourceAdapterInternalException("Failed configuring Mule", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.mbeanServer.unregisterMBean(this.objName);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Failed unregistering EventSwitchManager MBean");
        }
        this.manager.getMuleManager().dispose();
        EventSwitchManager.deleteInstance();
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return null;
    }
}

