/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: XmlCodeArea.as 7428 2011-01-13 14:41:29Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.common.controls
{
    import flash.events.Event;
    import flash.events.FocusEvent;
    import flash.events.MouseEvent;
    import flash.text.TextFormat;

    import mx.collections.ArrayCollection;
    import mx.controls.Alert;
    import mx.controls.TextArea;
    import mx.controls.textClasses.TextRange;
    import mx.events.FlexEvent;

    /**
     * A TextArea that provides syntax highlighting for XML
     * @author Ph Durieux
     */
    public class XmlCodeArea extends TextArea
    {
        /**
         * Syntax highlighting predefined formats
         */
        private var tagsFormat:TextFormat=new TextFormat();
        private var attrsFormat:TextFormat=new TextFormat();
        private var commentFormat:TextFormat=new TextFormat();
        private var quoteFormat:TextFormat=new TextFormat();

        /**
         * Build a new XmlCodeArea
         */
        public function XmlCodeArea()
        {
            super();
            this.setStyle("fontFamily", "monospace"), this.setStyle("fontSize", 14);

            // tags
            tagsFormat.color=0x0000FF;
            tagsFormat.bold=false;

            // attributes
            attrsFormat.color=0x00C0C0;
            attrsFormat.bold=false;

            // quoted text
            quoteFormat.color=0xB05050;
            quoteFormat.bold=false;

            // comments
            commentFormat.color=0x30C060;
            commentFormat.bold=false;

            // Listen to events
            // addEventListener(Event.CHANGE, highlightCode);
            addEventListener(FlexEvent.CREATION_COMPLETE, highlightCode);
            addEventListener(FlexEvent.UPDATE_COMPLETE, highlightCode);
            addEventListener(FocusEvent.FOCUS_IN, highlightCode);
            // addEventListener(FlexEvent.SHOW, highlightCode);
            addEventListener(MouseEvent.MOUSE_UP, highlightCode);
            // addEventListener(MouseEvent.MOUSE_WHEEL, highlightCode);
        }

        // possible values for highlighting context
        private var NONE:int=0;
        private var TAG:int=1;
        private var ATTR:int=2;
        private var COMMENT:int=3;
        private var QUOTE:int=4;

        // special characters
        private var CHAR_QU:Number="\"".charCodeAt(0);
        private var CHAR_GT:Number=">".charCodeAt(0);
        private var CHAR_LT:Number="<".charCodeAt(0);
        private var CHAR_MI:Number="-".charCodeAt(0);
        private var CHAR_EX:Number="!".charCodeAt(0);

        /**
         * Highlight the code
         */
        public function highlightCode(e:Event=null):void
        {
            var context:int=NONE;
            var previous:int=NONE;
            var start:int=0;
            for (var lineIndex:int=0; lineIndex < textField.numLines; lineIndex++)
            {
                var line:String=textField.getLineText(lineIndex);
                var pos:uint=textField.getLineOffset(lineIndex);
                var char:Number=0;
                var prec:Number=0;
                var ante:Number=0;
                for (var i:uint=0; i < line.length; i++)
                {
                    pos++;
                    ante=prec;
                    prec=char;
                    char=line.charCodeAt(i);

                    // comments
                    if (context == COMMENT)
                    {
                        // Inside a Comment
                        if (char == CHAR_GT && prec == CHAR_MI && ante == CHAR_MI)
                        {
                            // end of comment
                            context=previous;
                            textField.setTextFormat(commentFormat, start, pos);
                            start=0;
                        }
                        continue;
                    }
                    if (char == CHAR_MI && start == 0 && prec == CHAR_EX && ante == CHAR_LT)
                    {
                        // start of comment
                        previous=context;
                        context=COMMENT;
                        start=pos - 3;
                        continue;
                    }

                    // quoted text
                    if (context == QUOTE)
                    {
                        // Inside a quoted
                        if (char == CHAR_QU)
                        {
                            // end of quoted
                            context=previous;
                            textField.setTextFormat(quoteFormat, start, pos);
                            start=0;
                        }
                        continue;
                    }
                    if (char == CHAR_QU)
                    {
                        // start of quoted
                        previous=context;
                        context=QUOTE;
                        start=pos - 1;
                        continue;
                    }

                    // tags
                    if (char == CHAR_LT)
                    {
                        context=TAG;
                        continue;
                    }
                    if (char == CHAR_GT)
                    {
                        if (start > 0 && context == TAG)
                        {
                            // End of simple tag
                            textField.setTextFormat(tagsFormat, start, pos - 1);
                            start=0;
                        }
                        context=NONE;
                        continue;
                    }

                    // tags and attibutes
                    if (!isSeparator(char) && start == 0)
                    {
                        if (context == TAG || context == ATTR)
                        {
                            // start tag or attibute
                            start=pos - 1;
                        }
                        continue;
                    }
                    if (isSeparator(char) && start > 0)
                    {
                        if (context == TAG)
                        {
                            // End of tag with possible attributes defined
                            textField.setTextFormat(tagsFormat, start, pos - 1);
                            start=0;
                            context=ATTR;
                        }
                        else
                        {
                            if (context == ATTR)
                            {
                                // End of attribute
                                textField.setTextFormat(attrsFormat, start, pos - 1);
                                start=0;
                            }
                        }
                        continue;
                    }
                }
            }
        }

        /**
         * Checks whether the given char is a separator
         */
        private function isSeparator(char:Number):Boolean
        {
            var valids:String="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_";
            for (var i:int=0; i < valids.length; i++)
            {
                if (char == valids.charCodeAt(i))
                {
                    return false;
                }
            }
            return true;
        }
    }
}
