/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.common.view {

import mx.charts.chartClasses.Series;
import mx.charts.series.LineSeries;
import mx.graphics.Stroke;

public class LineChartClass extends CartesianChartClass {

    private var stroke:Stroke;

    public function LineChartClass() {
        stroke = new Stroke();
        stroke.weight = 1;
        stroke.alpha = 0.9;
    }

    protected override function buildSeries():Series {
        var series:LineSeries =  new LineSeries();
        series.yField = "value";
        series.xField = "date";
        series.setStyle("areaStroke", stroke);
        return series;
    }

}
}
