/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.common.renderers
{
import mx.collections.ArrayCollection;
import mx.containers.HBox;
import mx.controls.Alert;
import mx.controls.Button;
import mx.controls.DataGrid;
import mx.controls.dataGridClasses.DataGridListData;
import mx.controls.listClasses.BaseListData;


/**
 * This renderer provides a Button to insert in a grid. When clicking on it,
 * the ligne on wich the button is set is deleted.
 *
 * @author Guillaume Renault
 *
 */
public class DeleteRowButtonRendererClass extends HBox
{

    private var _listData:DataGridListData;

    [Bindable]
    private var deleteButton:Button;

    public function DeleteRowButtonRendererClass() {
        super();
    }

    override public function set data(value:Object):void {
        super.data = value;
    }

    override public function get data():Object {
        return super.data;
    }

    public function get listData():BaseListData {
        return _listData;
    }

    public function set listData(value:BaseListData):void {
        _listData = DataGridListData(value);
    }

    /**
    * Delete the row of the grid.
    */
    private function deleteRow():void {
        // get the grid
        // get the dataprovider of the grid
        // delete the ligne
        ((this.parent.parent as DataGrid).dataProvider as ArrayCollection).removeItemAt(this._listData.rowIndex);
    }


    /**
     * Called when Tree selection is being changed.
     */
    public function clickButton(event:Event):void {
            callLater(deleteRow);
    }

    protected function creationComplete():void {
        deleteButton = new Button;
        deleteButton.label = "Delete";
        deleteButton.addEventListener("click",clickButton);
        deleteButton.setStyle("fontSize", 7);
        deleteButton.height = 14;
        this.addChildAt(deleteButton, 0);

    }
}
}
