/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.common.view {

import mx.charts.HitData;
import mx.charts.chartClasses.Series;
import mx.charts.series.AreaSeries;

public class AreaChartClass extends CartesianChartClass {

    public function AreaChartClass() {
    }

    protected override function buildSeries():Series {
        var series:AreaSeries =  new AreaSeries();
        series.yField = "value";
        series.xField = "date";
        return series;
    }

    /**
     * String displayed as data tip for values
     * @param e HitData
     * @return String
     */
    public function dataTypeWithFullDate(e:HitData):String {
        var s:String;
        s = "<B>" + AreaSeries(e.element).displayName + "</B>\n";
        s += "<I>Value:</I> " + e.item.value + "\n";
        s += "<I>Date:</I> " + dateFormatter.format(e.item.date) + "\n";
        return s;
    }
}
}
