/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.common.jms;

import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.jasmine.monitoring.eos.common.EventManager;
import org.ow2.jasmine.monitoring.eos.common.jms.JMSMessageListener;

public class JMSConnection {
    public static final String INITIAL_CONTEXT_FACTORY = "org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory";
    public static final String TOPIC_FACTORY = "JTCF";
    public static final String TOPIC = "jasmine";
    protected static final int OK = 0;
    protected static final int ERROR = -1;
    protected MessageListener messageListener = null;
    protected InitialContext context = null;
    protected TopicConnectionFactory tcf = null;
    protected TopicConnection connection = null;
    protected TopicSession session = null;
    protected Topic topic = null;
    protected TopicSubscriber subscriber = null;
    private EventManager manager = null;

    public JMSConnection(EventManager evManager) {
        this.manager = evManager;
    }

    public int connect() {
        try {
            this.context = new InitialContext();
            Object o = this.context.lookup(TOPIC_FACTORY);
            this.tcf = (TopicConnectionFactory)o;
            this.topic = (Topic)this.context.lookup(TOPIC);
            this.messageListener = new JMSMessageListener(this.manager);
            this.connection = this.tcf.createTopicConnection();
            this.session = this.connection.createTopicSession(false, 2);
            this.subscriber = this.session.createSubscriber(this.topic);
            this.subscriber.setMessageListener(this.messageListener);
            this.connection.start();
        }
        catch (NamingException e) {
            return -1;
        }
        catch (JMSException e) {
            return -1;
        }
        return 0;
    }

    public int connect(String topicName, MessageListener evMessageListener) {
        try {
            this.context = new InitialContext();
            Object o = this.context.lookup(TOPIC_FACTORY);
            this.tcf = (TopicConnectionFactory)o;
            this.topic = (Topic)this.context.lookup(topicName);
            this.messageListener = evMessageListener;
            this.connection = this.tcf.createTopicConnection();
            this.session = this.connection.createTopicSession(false, 2);
            this.subscriber = this.session.createSubscriber(this.topic);
            this.subscriber.setMessageListener(this.messageListener);
            this.connection.start();
        }
        catch (NamingException e) {
            return -1;
        }
        catch (JMSException e) {
            return -1;
        }
        return 0;
    }

    public int disconnect() {
        try {
            if (this.connection != null) {
                this.session.close();
                this.connection.close();
            }
        }
        catch (Exception e) {
            return -1;
        }
        return 0;
    }
}

