/**
 * JASMINe
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineEventManager.java 4798 2009-08-07 12:30:47Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.eos.common;

import java.util.ArrayList;
import java.util.List;

import org.ow2.jasmine.monitoring.eos.common.jms.event.JasmineMessageEvent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;


/**
 * Events Manager. This class manages all the events from the JMS queue. Only
 * one instance of the manager must exist.
 *
 * @author Guillaume Renault
 *
 */
public class JasmineEventManager implements EventManager < JasmineMessageEvent > {

    /**
     * Logger.
     */
    private static Log logger = LogFactory.getLog(JasmineEventManager.class);

    /**
     * list of waiting events.
     */
    private List < JasmineMessageEvent > events = null;

    /**
     * Unique instance of the manager.
     */
    private JasmineEventManager instance = null;

    /**
     * Constructor of the manager. Initialize the list.
     */
    public JasmineEventManager() {
        this.events = new ArrayList < JasmineMessageEvent > ();
    }

    /**
     * Add an event in the list.
     *
     * @param event the event to add.
     */
    public void add(final JasmineMessageEvent event) {
        this.events.add(event);
    }

    /**
     * Clear the list once treated.
     */
    private void clear() {
        this.events.removeAll(this.events);
    }

    /**
     * Get the entire queue of waiting events.
     *
     * @return the queue of events.
     */
    public List < JasmineMessageEvent > getAll() {
        try {
            logger.debug("getting all");

            List <JasmineMessageEvent > l = new ArrayList < JasmineMessageEvent >();
            l.addAll(this.events);

            return l;
        } finally {
            this.clear();
        }
    }

}
