/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.common.jms;

import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import org.ow2.jasmine.monitoring.eos.common.EventManager;
import org.ow2.jasmine.monitoring.eos.common.jms.JMSMessageListener;

public class JMSConnection {
    public static final String TOPIC_FACTORY = "JTCF";
    private EventManager manager = null;
    protected Topic topic = null;
    protected TopicConnection connection = null;
    protected TopicSession session = null;
    protected TopicSubscriber subscriber = null;

    public JMSConnection(EventManager evManager) {
        this.manager = evManager;
    }

    public void connect(String topicName) throws Exception {
        this.connect(topicName, new JMSMessageListener(this.manager));
    }

    public void connect(String topicName, MessageListener listener) throws Exception {
        InitialContext context = new InitialContext();
        Object o = context.lookup(TOPIC_FACTORY);
        TopicConnectionFactory tcf = (TopicConnectionFactory)o;
        this.topic = (Topic)context.lookup(topicName);
        this.connection = tcf.createTopicConnection();
        this.session = this.connection.createTopicSession(false, 2);
        this.subscriber = this.session.createSubscriber(this.topic);
        this.subscriber.setMessageListener(listener);
        this.connection.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendObjectMessage(Serializable object) throws Exception {
        if (this.connection == null) {
            throw new JMSException("Not connected!");
        }
        TopicSession session = this.connection.createTopicSession(false, 2);
        MessageProducer producer = session.createProducer((Destination)this.topic);
        try {
            ObjectMessage m = session.createObjectMessage(object);
            producer.send((Message)m);
        }
        finally {
            producer.close();
            session.close();
            producer = null;
            session = null;
            System.gc();
        }
    }

    public void disconnect() throws Exception {
        if (this.connection != null) {
            this.subscriber.close();
            this.session.close();
            this.connection.close();
            this.connection = null;
            this.session = null;
            this.topic = null;
            this.subscriber = null;
            System.gc();
        }
    }
}

