/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eos.common.jndilocator;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.jasmine.monitoring.eos.common.jndilocator.ServiceLocatorException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ServiceLocator {
    private static final Log LOGGER = LogFactory.getLog(ServiceLocator.class);
    private Context initialContext;
    private Map<String, Object> cache;
    private static final ServiceLocator instance = new ServiceLocator();

    public static ServiceLocator getInstance() {
        return instance;
    }

    private ServiceLocator() throws ServiceLocatorException {
        try {
            this.initialContext = this.getInitialContext();
            this.cache = new HashMap<String, Object>();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error starting ServiceLocator", new Object[]{e});
            throw new ServiceLocatorException(e);
        }
    }

    public Context getInitialContext() throws ServiceLocatorException {
        try {
            return new InitialContext();
        }
        catch (NamingException ne) {
            LOGGER.error((Object)"Error getting Initial Context", new Object[]{ne});
            throw new ServiceLocatorException(ne);
        }
    }

    public Context getInitialContext(String url) throws ServiceLocatorException {
        try {
            Properties h = new Properties();
            h.put("java.naming.factory.initial", "org.objectweb.carol.jndi.spi.MultiOrbInitialContextFactory");
            h.put("java.naming.provider.url", url);
            return new InitialContext(h);
        }
        catch (NamingException ne) {
            LOGGER.error((Object)"Error getting Initial Context", new Object[]{ne});
            throw new ServiceLocatorException(ne);
        }
    }

    public synchronized Object getRemoteObject(String jndiName) throws ServiceLocatorException {
        Object remoteObject = this.cache.get(jndiName);
        if (remoteObject == null) {
            try {
                remoteObject = this.initialContext.lookup(jndiName);
                this.cache.put(jndiName, remoteObject);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error getting remote object", new Object[]{e});
                throw new ServiceLocatorException(e);
            }
        }
        return remoteObject;
    }
}

